<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\helper\helper;
use App\Models\Category;
use App\Models\Products;
use App\Models\ProductImage;
use App\Models\SubCategory;
use App\Models\Variation;
use App\Models\Testimonials;
use App\Models\Cart;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\ImportProduct;
use PDF;
class ProductController extends Controller
{
    public function index()
    {
        if(Auth::user()->type == 4)
        {
            $vendor_id = Auth::user()->vendor_id;
        }else{
            $vendor_id = Auth::user()->id;
        }
        $getproductslist = Products::with('product_image', 'multi_variation', 'category_info')->where('vendor_id', $vendor_id)->where('is_deleted', 2)->orderBy('reorder_id')->get();
        return view('admin.product.product', compact('getproductslist'));
    }
    public function add(Request $request)
    {
        if(Auth::user()->type == 4)
        {
            $vendor_id = Auth::user()->vendor_id;
        }else{
            $vendor_id = Auth::user()->id;
        }
        $checkplan = helper::checkplan($vendor_id,'');
        $v = json_decode(json_encode($checkplan));
        if (@$v->original->status == 2) {
            return redirect('admin/products')->with('error', @$v->original->message);
        }
        $getcategorylist = Category::where('is_available', 1)->where('is_deleted', 2)->where('vendor_id', $vendor_id)->get();
        return view('admin.product.add_product', compact("getcategorylist"));
    }
    public function save(Request $request)
    {
        if(Auth::user()->type == 4)
        {
            $vendor_id = Auth::user()->vendor_id;
        }else{
            $vendor_id = Auth::user()->id;
        }
        $checkplan = helper::checkplan($vendor_id,'');
        $v = json_decode(json_encode($checkplan));
        if (@$v->original->status == 2) {
            return redirect('admin/products')->with('error', @$v->original->message);
        }
        $request->validate([
            'product_name' => 'required',
            'product_image' => 'required',
            'product_image.*' => 'image',
            'price' => 'required_if:has_variation,2',
            'description' => 'required',
            'tax' => 'required',
            'category' => 'required',
        ], [
                'product_name.required' => trans('messages.name_required'),
                'price.required_if' => trans('messages.price_required'),
                'description.required' => trans('messages.description_required'),
                'product_image.required' => trans('messages.image_required'),
                'tax.required' => trans('messages.tax_required'),
                'category.required' => trans('messages.category_required')
            ]);
        $check_slug = Products::where('slug', Str::slug($request->product_name, '-'))->first();
        if (!empty($check_slug)) {
            $last_id = Products::select('id')->orderByDesc('id')->first()->id;
            $slug = Str::slug($request->product_name . ' ' . $last_id, '-');
        } else {
            $slug = Str::slug($request->product_name, '-');
        }
        $price = $request->price;
        $original_price = $request->original_price;
        if ($request->has_variation == 1) {
            foreach ($request->variation as $key => $no) {
                if (@$no != "" && @$request->variation_price[$key] != "" && @$request->variation_original_price[$key] != "") {
                    $price = $request->variation_price[$key];
                    $original_price = $request->variation_original_price[$key];
                    break;
                }
            }
        }
        $product = new Products();
        $product->vendor_id = $vendor_id;
        $product->category_id = $request->category;
        $product->sub_category_id = $request->sub_category;
        $product->name = $request->product_name;
        $product->slug = $slug;
        $product->price = $price;
        $product->original_price = $original_price;
        $product->sku = $request->product_sku;
        $product->qty = $request->qty;
        $product->low_qty = $request->low_qty;
        $product->attribute = $request->has_variation == 1 ? $request->attribute : "";
        $product->has_variation = $request->has_variation;
        $product->tax = $request->tax;
        $product->description = $request->description;
        $product->additional_info = $request->additional_info;
        $product->save();
        if ($request->has('product_image')) {
            foreach ($request->file('product_image') as $file) {
                $reimage = 'product-' . uniqid() . "." . $file->getClientOriginalExtension();
                $file->move(storage_path('app/public/admin-assets/images/product/'), $reimage);
                $image = new ProductImage();
                $image->product_id = $product->id;
                $image->image = $reimage;
                $image->save();
            }
        }
      
        if ($request->has_variation == 1) {
            foreach ($request->variation as $key => $no) {
                if (@$no != "" && @$request->variation_price[$key] != "" && @$request->variation_original_price[$key] != "") {
                    $variation = new Variation();
                    $variation->product_id = $product->id;
                    $variation->name = $no;
                    $variation->price = $request->variation_price[$key];
                    $variation->original_price = $request->variation_original_price[$key];
                    $variation->qty = $request->variation_qty[$key];
                    $variation->save();
                }
            }
        }
        return redirect('admin/products/')->with('success', trans('messages.success'));
    }
    public function edit($slug)
    {
        if(Auth::user()->type == 4)
        {
            $vendor_id = Auth::user()->vendor_id;
        }else{
            $vendor_id = Auth::user()->id;
        }
        $getproductdata = Products::with('multi_image')->where('slug', $slug)->first();
        $getcategorylist = Category::where('is_available', 1)->where('is_deleted', 2)->where('vendor_id', $vendor_id)->get();
        $getsubcategorylist = SubCategory::where('is_available', 1)->where('is_deleted', 2)->where('category_id', @$getproductdata->category_id)->get();
        $productreview = Testimonials::where('product_id',$getproductdata->id)->where('vendor_id',$vendor_id)->get();
        return view('admin.product.edit_product', compact('getproductdata', 'getcategorylist', 'getsubcategorylist','productreview'));
    }
    public function update_product(Request $request, $slug)
    {
        $request->validate([
            'product_name' => 'required',
            'price' => 'required',
            'description' => 'required',
            'tax' => 'required',
            'category' => 'required',
        ], [
            'product_name.required' => trans('messages.name_required'),
            'price.required' => trans('messages.price_required'),
            'description.required' => trans('messages.description_required'),
            'tax.required' => trans('messages.tax_required'),
            'category.required' => trans('messages.category_required')
        ]);
        try {
            $price = $request->price;
            $original_price = $request->original_price;
            if ($request->has_variation == 1) {
                $variation_id = $request->variation_id;
                foreach ($request->variation as $key => $no) {
                    if (@$no != "" && @$request->variation_price[$key] != "" && @$request->variation_original_price[$key] != "") {
                        if (@$variation_id[$key] == "") {
                            $price = $request->variation_price[$key];
                            $original_price = $request->variation_original_price[$key];
                            break;
                        } else if (@$variation_id[$key] != "") {
                            $price = $request->variation_price[$key];
                            $original_price = $request->variation_original_price[$key];
                            break;
                        }
                    }
                }
            }
            $product = Products::where('slug', $slug)->first();
            $product->category_id = $request->category;
            $product->sub_category_id = $request->sub_category;
            $product->name = $request->product_name;
            $product->price = $price;
            $product->original_price = $original_price;
            $product->sku = $request->product_sku;
            $product->qty = $request->qty;
            $product->low_qty = $request->low_qty;
            $product->attribute = $request->has_variation == 1 ? $request->attribute : "";
            $product->has_variation = $request->has_variation;
            $product->tax = $request->tax;
            $product->description = $request->description;
            $product->additional_info = $request->additional_info;
            $product->update();
            if ($request->has_variation == 2) {
                Variation::where('product_id', $product->id)->delete();
            }
            if ($request->has_variation == 1) {
                $variation_id = $request->variation_id;
                foreach ($request->variation as $key => $no) {
                    if (@$no != "" && @$request->variation_price[$key] != "" && @$request->variation_original_price[$key] != "") {
                        if (@$variation_id[$key] == "") {
                            $variation = new Variation();
                            $variation->product_id = $product->id;
                            $variation->name = $no;
                            $variation->price = $request->variation_price[$key];
                            $variation->original_price = $request->variation_original_price[$key];
                            $variation->qty = $request->variation_qty[$key];
                            $variation->save();
                        } else if (@$variation_id[$key] != "") {
                            Variation::where('id', @$variation_id[$key])->update(['price' => $request->variation_price[$key], 'name' => $request->variation[$key], 'original_price' => $request->variation_original_price[$key]]);
                        }
                    }
                }
            }
            return redirect('admin/products')->with('success', trans('messages.success'));
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    public function update_image(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'product_image' => 'required|image'
        ], [
                'product_image.required' => trans('messages.image_required'),
                'product_image.image' => trans('messages.valid_image')
            ]);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput()->with('error', trans('messages.wrong'));
        } else {
            if ($request->has('product_image')) {
                if (file_exists(storage_path('app/public/admin-assets/images/product/' . $request->image))) {
                    unlink(storage_path('app/public/admin-assets/images/product/' . $request->image));
                }
                $productimage = 'product-' . uniqid() . "." . $request->file('product_image')->getClientOriginalExtension();
                $request->file('product_image')->move(storage_path('app/public/admin-assets/images/product/'), $productimage);
                ProductImage::where('id', $request->id)->update(['image' => $productimage]);
                return redirect()->back()->with('success', trans('messages.success'));
            } else {
                return redirect()->back()->with('error', trans('messages.wrong'));
            }
        }
    }
    public function delete_product($slug)
    {
        try {
            $checkproduct = Products::where('slug', $slug)->first();
            $checkproduct->is_deleted = 1;
            $checkproduct->save();
            Cart::where('product_id', $checkproduct->id)->delete();
            return redirect()->back()->with('success', trans('messages.success'));
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', trans('messages.wrong'));
        }
    }
    public function delete_image($id, $service_id)
    {
        $count = ProductImage::where('product_id', $service_id)->count();
        if ($count > 1) {
            ProductImage::where('id', $id)->delete();
            return redirect()->back()->with('success', trans('messages.success'));
        } else {
            return redirect()->back()->with('msg', trans('messages.last_image'));
        }
    }
    public function delete_variation(Request $request)
    {
        $checkvariationcount = Variation::where('product_id', $request->product_id)->count();
        if ($checkvariationcount > 1) {
            $UpdateDetails = Variation::where('id', $request->id)->delete();
            if ($UpdateDetails) {
                Cart::where('variation_id', $request->id)->delete();
                return redirect()->back()->with('success', trans('messages.success'));
            } else {
                return redirect()->back()->with('error', trans('messages.wrong'));
            }
        } else {
            return redirect()->back()->with('error', trans('messages.last_variation'));
        }
    }
    public function add_image(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'image' => 'required|image'
        ], [
                'image.required' => trans('messages.image_required'),
                'image.image' => trans('messages.valid_image')
            ]);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput()->with('error', trans('messages.wrong'));
        } else {
            $productimage = new ProductImage();
            $productimage->product_id = $request->product_id;
            if ($request->has('image')) {
                $image = 'product-' . uniqid() . "." . $request->file('image')->getClientOriginalExtension();
                $request->file('image')->move(storage_path('app/public/admin-assets/images/product/'), $image);
                $productimage->image = $image;
            }
            $productimage->save();
            return redirect()->back()->with('success', trans('messages.success'));
        }
    }
    public function status_change($slug, $status)
    {
        $checkproduct = Products::where('slug', $slug)->first();
        $checkproduct->is_available = $status;
        $checkproduct->save();
        if ($status == 2) {
            Cart::where('product_id', $checkproduct->id)->delete();
        }
        return redirect('admin/products')->with('success', trans('messages.success'));
    }
    public function subcategories(Request $request)
    {
        $data = helper::getsubcategories($request->id, "");
        return response()->json(['status' => 1, 'message' => trans('messages.success'), 'data' => $data], 200);
    }
    public function import()
    {
        if(Auth::user()->type == 4)
        {
            $vendor_id = Auth::user()->vendor_id;
        }else{
            $vendor_id = Auth::user()->id;
        }
        $checkplan = helper::checkplan($vendor_id,'');
        $v = json_decode(json_encode($checkplan));
        if (@$v->original->status == 2) {
            return redirect('admin/products')->with('error', @$v->original->message);
        }
        return view('admin.import.import');
    }
    public function generatepdf()
    {
        $categorylist = Category::where('is_available', 1)->where('is_deleted',2)->where('vendor_id',Auth::user()->id)->get();
        $pdf = PDF::loadView('admin.product.categorylist',['categorylist'=> $categorylist]);
        return $pdf->download('category.pdf');
    }
    public function generatepdf_subcategory()
    {
        $subcategorylist = SubCategory::with('category_info')->where('is_available', 1)->where('is_deleted',2)->where('vendor_id',Auth::user()->id)->get();
        $pdf = PDF::loadView('admin.product.subcategorylist',['subcategorylist'=> $subcategorylist]);
        return $pdf->download('subcategory.pdf');
    }
    public function importproduct(Request $request){
        try {
            Excel::import(new ImportProduct(), $request->file('importfile')->store('files'));
            return redirect('/admin/products')->with('success',trans('messages.success'));
        } catch (\Throwable $th) {
            return redirect('/admin/products')->with('error',trans('messages.wrong'));
        }
    }
    public function reorder_category(Request $request)
    {
        if(Auth::user()->type == 4)
        {
            $vendor_id = Auth::user()->vendor_id;
        }else{
            $vendor_id = Auth::user()->id;
        }
        $getproducts = Products::where('vendor_id',$vendor_id)->get();
        foreach ($getproducts as $product) {
            foreach ($request->order as $order) {
               $product = products::where('id',$order['id'])->first();
               $product->reorder_id = $order['position'];
               $product->save();
            }
        }
        return response()->json(['status' => 1,'success'=>trans('messages.success'),'msg' => trans('messages.success')], 200);
    }
    public function delete_review(Request $request)
    {
        $deletereview = Testimonials::where('id',$request->id)->first();
        $deletereview->delete();
        return redirect()->back()->with('success',trans('messages.success'));
    }
    public function top_deals(Request $request)
    {
        $product = Products::where('slug',$request->slug)->where('vendor_id',Auth::user()->id)->first();
        $product->top_deals = $request->status;
        $product->update();
        return redirect()->back()->with('success',trans('messages.success'));
    }
}