<table class="table table-striped table-bordered py-3 zero-configuration w-100">
    <thead>
        <tr class="text-uppercase fw-500">
            <td>{{ trans('labels.srno') }}</td>
            <td>{{ trans('labels.order_number') }}</td>
            <td>{{ trans('labels.date_time') }}</td>
            <td>{{ trans('labels.total') }} {{ trans('labels.amount') }}</td>
            <td>{{ trans('labels.payment_type') }}</td>
            <td>{{ trans('labels.status') }}</td>
            <td>{{ trans('labels.action') }}</td>
        </tr>
    </thead>
    <tbody>
        @php $i = 1; @endphp
        @foreach ($getorders as $orderdata)
            <tr id="dataid{{ $orderdata->id }}" class="fs-7">
                <td>@php echo $i++; @endphp</td>
                <td>#{{ $orderdata->order_number }}</td>
                <td>{{ helper::date_formate($orderdata->created_at) }}</td>
                <td>{{ helper::currency_formate($orderdata->grand_total, $orderdata->vendor_id) }}</td>
                <td>
                    {{ @helper::getpayment($orderdata->transaction_type,Auth::user()->id)->payment_name }} 
                </td>
                <td>
                    @if ($orderdata->status == '1')
                        <span class="badge bg-warning">{{ trans('labels.pending') }}</span>
                    @elseif($orderdata->status == '2')
                        <span class="badge bg-info">{{ trans('labels.accepted') }}</span>
                    @elseif($orderdata->status == '3')
                        <span class="badge bg-danger">{{ trans('labels.rejected') }}</span>
                    @elseif($orderdata->status == '4')
                        <span class="badge bg-danger">{{ trans('labels.cancelled') }}</span>
                    @elseif($orderdata->status == '5')
                        <span class="badge bg-success">{{ trans('labels.completed') }}</span>
                    @else
                        --
                    @endif
                </td>
                <td>
                    @if (Auth::user()->type == 2)
                        <a class="btn btn-sm btn-outline-primary" tooltip="{{trans('labels.print')}}"
                            href="{{ URL::to('admin/orders/print/' . $orderdata->order_number) }}"> <i
                                class="fa-regular fa-print"></i> </a>
                    @endif
                    <a class="btn btn-sm btn-outline-secondary" tooltip="{{trans('labels.view')}}"
                        href="{{ URL::to('admin/orders/invoice/' . $orderdata->order_number) }}"> <i
                            class="fa-regular fa-eye"></i></a>
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
