@php
    if (Auth::user()->type == 4) {
        $vendor_id = Auth::user()->vendor_id;
    } else {
        $vendor_id = Auth::user()->id;
    }
@endphp
@extends('admin.layout.default')
@section('content')
    <div class="d-flex align-items-center mb-3">
        <h5 class="text-uppercase">{{ trans('labels.payment_settings') }}</h5>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card border-0">
                <div class="card-body">
                    <div class="accordion accordion-flush" id="accordionExample">
                        @php
                            $i = 1;
                        @endphp
                        @foreach ($getpayment as $key => $pmdata)
                            <form action="{{ URL::to('admin/payment/update') }}" method="POST" class="payments"
                                enctype="multipart/form-data">
                                @csrf
                                @php
                                    $transaction_type = strtolower($pmdata->payment_type);
                                    $image_tag_name = $transaction_type . '_image';
                                @endphp
                                <input type="hidden" name="payment_id" value="{{ $pmdata->payment_type }}">
                                <input type="hidden" name="payment_name" value="{{ $transaction_type }}">
                                <div class="accordion-item card rounded border mb-3">
                                    <h2 class="accordion-header d-flex align-items-center"
                                        id="heading{{ $transaction_type }}">
                                        <button
                                            class="{{ session()->get('direction') == 2 ? 'accordion-button-rtl' : 'accordion-button' }} rounded collapsed"
                                            type="button" data-bs-toggle="collapse"
                                            data-bs-target="#targetto-{{ $i }}-{{ $transaction_type }}"
                                            aria-expanded="false"
                                            aria-controls="targetto-{{ $i }}-{{ $transaction_type }}">
                                            <img src="{{ helper::image_path($pmdata->image) }}" alt=""
                                                class="img-fluid rounded me-2" height="30" width="30">
                                            <b>{{ $pmdata->payment_name }}</b>
                                            @if ($transaction_type == '7' || $transaction_type == '8' || $transaction_type == '9' || $transaction_type == '10')
                                                @if (env('Environment') == 'sendbox')
                                                    <span
                                                        class="badge badge bg-danger ms-2">{{ trans('labels.addon') }}</span>
                                                @endif
                                            @endif
                                        </button>
                                    </h2>
                                    <div id="targetto-{{ $i }}-{{ $transaction_type }}"
                                        class="accordion-collapse collapse"
                                        aria-labelledby="heading{{ $transaction_type }}"
                                        data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <div class="row">
                                                <div class="col-md-6 form-group">
                                                    <label class="form-label">
                                                        {{ trans('labels.name') }} <span class="text-danger">
                                                            *</span> </label>
                                                    <input type="text" class="form-control" name="name"
                                                        placeholder="{{ trans('labels.name') }}"
                                                        value="{{ $pmdata->payment_name }}" required>
                                                </div>
                                                @if ($transaction_type == '6')
                                                    <div class="col-md-3">
                                                        <div class="form-group">
                                                            <label class="form-label">
                                                                {{ trans('labels.bank_name') }} <span class="text-danger">
                                                                    *</span> </label>
                                                            <input type="text" class="form-control" name="bank_name"
                                                                placeholder="{{ trans('labels.bank_name') }}"
                                                                value="{{ $pmdata->bank_name }}" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3 d-flex justify-content-end align-items-center">
                                                        <input id="checkbox-switch-{{ $transaction_type }}"
                                                            type="checkbox" class="checkbox-switch"
                                                            name="is_available[{{ $transaction_type }}]" value="1"
                                                            {{ $pmdata->is_available == 1 ? 'checked' : '' }}>
                                                        <label for="checkbox-switch-{{ $transaction_type }}"
                                                            class="switch">
                                                            <span
                                                                class="{{ session()->get('direction') == 2 ? 'switch__circle-rtl' : 'switch__circle' }}"><span
                                                                    class="switch__circle-inner"></span></span>
                                                            <span
                                                                class="switch__left {{ session()->get('direction') == 2 ? 'pe-2' : 'ps-2' }}">{{ trans('labels.off') }}</span>
                                                            <span
                                                                class="switch__right {{ session()->get('direction') == 2 ? 'ps-2' : 'pe-2' }}">{{ trans('labels.on') }}</span>
                                                        </label>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="form-label">
                                                                {{ trans('labels.account_holder_name') }} <span
                                                                    class="text-danger"> *</span> </label>
                                                            <input type="text" class="form-control"
                                                                name="account_holder_name"
                                                                placeholder="{{ trans('labels.account_holder_name') }}"
                                                                value="{{ $pmdata->account_holder_name }}" required>
                                                        </div>
                                                    </div>
                                                  
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="form-label">
                                                                {{ trans('labels.account_number') }} <span
                                                                    class="text-danger"> *</span></label>
                                                            <input type="text" class="form-control" name="account_number"
                                                                placeholder="{{ trans('labels.account_number') }}"
                                                                @if (env('Environment') == 'sendbox') value = "*********"  @else value="{{ $pmdata->account_number }}" @endif
                                                                required>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="form-label">
                                                                {{ trans('labels.bank_ifsc_code') }} <span
                                                                    class="text-danger"> *</span></label>
                                                            <input type="text" class="form-control" name="bank_ifsc_code"
                                                                placeholder="{{ trans('labels.bank_ifsc_code') }}"
                                                                @if (env('Environment') == 'sendbox') value = "*********" @else value="{{ $pmdata->bank_ifsc_code }}" @endif required>
                                                        </div>
                                                    </div>
                                                @endif
                                                @if (in_array($transaction_type, ['2', '3', '4', '5', '7', '8', '9', '10']))
                                                    <div class="col-md-3">
                                                        <p class="form-label">{{ trans('labels.environment') }}</p>
                                                        <div class="form-check form-check-inline">
                                                            <input class="form-check-input" type="radio"
                                                                name="environment[{{ $transaction_type }}]"
                                                                id="{{ $transaction_type }}_{{ $key }}_environment"
                                                                value="1"
                                                                {{ $pmdata->environment == 1 ? 'checked' : '' }}>
                                                            <label class="form-check-label"
                                                                for="{{ $transaction_type }}_{{ $key }}_environment">
                                                                {{ trans('labels.sandbox') }} </label>
                                                        </div>
                                                        <div class="form-check form-check-inline">
                                                            <input class="form-check-input" type="radio"
                                                                name="environment[{{ $transaction_type }}]"
                                                                id="{{ $transaction_type }}_{{ $i }}_environment"
                                                                value="2"
                                                                {{ $pmdata->environment == 2 ? 'checked' : '' }}>
                                                            <label class="form-check-label"
                                                                for="{{ $transaction_type }}_{{ $i }}_environment">
                                                                {{ trans('labels.production') }} </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3 d-flex justify-content-end align-items-center">
                                                        <input id="checkbox-switch-{{ $transaction_type }}"
                                                            type="checkbox" class="checkbox-switch"
                                                            name="is_available[{{ $transaction_type }}]" value="1"
                                                            {{ $pmdata->is_available == 1 ? 'checked' : '' }}>
                                                        <label for="checkbox-switch-{{ $transaction_type }}"
                                                            class="switch">
                                                            <span
                                                                class="{{ session()->get('direction') == 2 ? 'switch__circle-rtl' : 'switch__circle' }}"><span
                                                                    class="switch__circle-inner"></span></span>
                                                            <span
                                                                class="switch__left {{ session()->get('direction') == 2 ? 'pe-2' : 'ps-2' }}">{{ trans('labels.off') }}</span>
                                                            <span
                                                                class="switch__right {{ session()->get('direction') == 2 ? 'ps-2' : 'pe-2' }}">{{ trans('labels.on') }}</span>
                                                        </label>
                                                    </div>
                                                    <div
                                                        class="col-md-6 {{ $transaction_type == '7' ? 'd-none' : '' }}  {{ $transaction_type == '9' ? 'd-none' : '' }}">
                                                        <div class="form-group">
                                                            <label for="{{ $transaction_type }}_publickey"
                                                                class="form-label">
                                                                {{ trans('labels.public_key') }} <span
                                                                    class="text-danger"> *</span></label>
                                                            <input type="text" id="{{ $transaction_type }}_publickey"
                                                                class="form-control"
                                                                name="public_key[{{ $transaction_type }}]"
                                                                placeholder="{{ trans('labels.public_key') }}"
                                                                @if (env('Environment') == 'sendbox') value="*********" @else value="{{ $pmdata->public_key }}" @endif
                                                                required>
                                                        </div>
                                                    </div>
                                                    <div
                                                        class=" {{ $transaction_type == '7' ? 'col-md-12' : 'col-md-6' }} {{ $transaction_type == '9' ? 'col-md-12' : 'col-md-6' }}">
                                                        <div class="form-group">
                                                            <label for="{{ $transaction_type }}_secretkey"
                                                                class="form-label">
                                                                {{ trans('labels.secret_key') }} <span
                                                                    class="text-danger"> *</span></label>
                                                            <input type="text" id="{{ $transaction_type }}_secretkey"
                                                                class="form-control"
                                                                name="secret_key[{{ $transaction_type }}]"
                                                                placeholder="{{ trans('labels.secret_key') }}"
                                                                @if (env('Environment') == 'sendbox') value="*********" @else value="{{ $pmdata->secret_key }}" @endif
                                                                required>
                                                        </div>
                                                    </div>
                                                    @if ($transaction_type == '4')
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <label for="encryption_key"
                                                                    class="form-label">{{ trans('labels.encryption_key') }}
                                                                    <span class="text-danger"> *</span>
                                                                </label>
                                                                <input type="text" id="encryptionkey"
                                                                    class="form-control" name="encryption_key"
                                                                    placeholder="{{ trans('labels.encryption_key') }}"
                                                                    @if (env('Environment') == 'sendbox') value="*********" @else
                                                                        value="{{ $pmdata->encryption_key }}" @endif
                                                                    required>
                                                            </div>
                                                        </div>
                                                    @endif
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="image" class="form-label">
                                                                {{ trans('labels.image') }} </label>
                                                            <input type="file" class="form-control" name="image">
                                                            <img src="{{ helper::image_path($pmdata->image) }}"
                                                                alt="" class="img-fluid rounded hw-50 mt-1">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="{{ $transaction_type }}currency"
                                                                class="form-label"> {{ trans('labels.currency') }}
                                                                <span class="text-danger"> *</span>
                                                            </label>
                                                            <input type="text" id="{{ $transaction_type }}currency"
                                                                class="form-control"
                                                                name="currency[{{ $transaction_type }}]"
                                                                placeholder="{{ trans('labels.currency') }}"
                                                                value="{{ $pmdata->currency }}" required>
                                                        </div>
                                                    </div>
                                                @elseif($transaction_type == 1)
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="image" class="form-label">
                                                                {{ trans('labels.image') }} </label>
                                                            <input type="file" class="form-control" name="image">
                                                            <img src="{{ helper::image_path($pmdata->image) }}"
                                                                alt="" class="img-fluid rounded hw-50 mt-1">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 d-flex align-items-center">
                                                        <input id="checkbox-switch-{{ $transaction_type }}"
                                                            type="checkbox" class="checkbox-switch"
                                                            name="is_available[{{ $transaction_type }}]" value="1"
                                                            {{ $pmdata->is_available == 1 ? 'checked' : '' }}>
                                                        <label for="checkbox-switch-{{ $transaction_type }}"
                                                            class="switch">
                                                            <span
                                                                class="{{ session()->get('direction') == 2 ? 'switch__circle-rtl' : 'switch__circle' }}"><span
                                                                    class="switch__circle-inner"></span></span>
                                                            <span
                                                                class="switch__left {{ session()->get('direction') == 2 ? 'pe-2' : 'ps-2' }}">{{ trans('labels.off') }}</span>
                                                            <span
                                                                class="switch__right {{ session()->get('direction') == 2 ? 'ps-2' : 'pe-2' }}">{{ trans('labels.on') }}</span>
                                                        </label>
                                                    </div>
                                                @endif
                                                <div class="form-group text-end">
                                                    <button
                                                        class="btn btn-secondary {{ Auth::user()->type == 4 ? (helper::check_access('role_payment_methods', Auth::user()->role_id, $vendor_id, 'add') == 1 || helper::check_access('role_payment_methods', Auth::user()->role_id, $vendor_id, 'edit') == 1 ? '' : 'd-none') : '' }}"
                                                        @if (env('Environment') == 'sendbox') type="button" onclick="myFunction()" @else type="submit" @endif>{{ trans('labels.save') }}</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </form>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script src="{{ url(env('ASSETPATHURL') . 'admin-assets/js/payment.js') }}"></script>
@endsection
