@extends('admin.layout.default')
@php
    if (Auth::user()->type == 4) {
        $vendor_id = Auth::user()->vendor_id;
    } else {
        $vendor_id = Auth::user()->id;
    }
@endphp
@section('content')

    <div class="d-flex justify-content-between align-items-center ">
        <h5 class="text-uppercase">{{ trans('labels.edit') }}</h5>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb m-0">
                <li class="breadcrumb-item"><a href="{{ URL::to('admin/products') }}">{{ trans('labels.products') }}</a></li>
                <li class="breadcrumb-item active {{ session()->get('direction') == 2 ? 'breadcrumb-rtl' : '' }}"
                    aria-current="page">{{ trans('labels.edit') }}</li>
            </ol>
        </nav>
    </div>
    <div class="row mt-3">
        <div class="col-12">
            <div class="card border-0 box-shadow">
                <div class="card-body">
                    @if (!empty($getproductdata))
                        <form action="{{ URL::to('admin/products/update-' . $getproductdata->slug) }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="row">
                                        <div class="col-md-12 form-group">
                                            <label class="form-label">{{ trans('labels.category') }} <span
                                                    class="text-danger"> * </span></label>
                                            <select class="form-select" name="category" id="editcat_id"
                                                data-url="{{ URL::to('admin/products/subcategories') }}" required>
                                                <option value="">{{ trans('labels.select') }}</option>
                                                @foreach ($getcategorylist as $catdata)
                                                    <option value="{{ $catdata->id }}" data-id="{{ $catdata->id }}"
                                                        {{ $getproductdata->category_id == $catdata->id ? 'selected' : '' }}>
                                                        {{ $catdata->name }} </option>
                                                @endforeach
                                            </select>
                                            @error('category')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div class="col-md-12 form-group">
                                            <label class="form-label">{{ trans('labels.sub_category') }}</label>
                                            <select class="form-select" name="sub_category" id="sub_category"
                                                data-old="{{ old('sub_category') }}">
                                                <option value="">{{ trans('labels.select') }}</option>
                                                @foreach ($getsubcategorylist as $subcatdata)
                                                    <option value="{{ $subcatdata->id }}" data-id="{{ $subcatdata->id }}"
                                                        {{ $getproductdata->sub_category_id == $subcatdata->id ? 'selected' : '' }}>
                                                        {{ $subcatdata->name }}</option>
                                                @endforeach
                                            </select>
                                            @error('sub_category')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="row">
                                        <div class="col-12 form-group">
                                            <label class="form-label">{{ trans('labels.name') }} <span class="text-danger">
                                                    * </span></label>
                                            <input type="text" class="form-control" name="product_name"
                                                value="{{ $getproductdata->name }}"
                                                placeholder="{{ trans('labels.name') }}" required>
                                            @error('product_name')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div class="col-12 form-group">
                                            <label class="form-label">{{ trans('labels.tax') }}<span class="text-danger"> *
                                                </span></label>
                                            <input type="text" class="form-control" name="tax"
                                                value="{{ $getproductdata->tax }}"
                                                placeholder="{{ trans('labels.tax') }}">
                                            @error('tax')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="has_variation"
                                            class="col-form-label">{{ trans('labels.product_has_variation') }}</label>
                                        <div class="col-md-12">
                                            <div class="form-check-inline">
                                                <input class="form-check-input me-0 has_variation" type="radio"
                                                    name="has_variation" id="no" value="2" checked
                                                    @if ($getproductdata->has_variation == 2) checked @endif>
                                                <label class="form-check-label"
                                                    for="no">{{ trans('labels.no') }}</label>
                                            </div>
                                            <div class="form-check-inline">
                                                <input class="form-check-input me-0 has_variation" type="radio"
                                                    name="has_variation" id="yes" value="1"
                                                    @if ($getproductdata->has_variation == 1) checked @endif>
                                                <label class="form-check-label"
                                                    for="yes">{{ trans('labels.yes') }}</label>
                                            </div>
                                            @error('has_variation')
                                                <br><span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row @if ($getproductdata->has_variation == 1) dn @endif" id="price_row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">{{ trans('labels.price') }} <span class="text-danger"> *
                                            </span></label>
                                        <input type="text" class="form-control numbers_only" name="price"
                                            value="{{ $getproductdata->price }}" placeholder="{{ trans('labels.price') }}"
                                            id="price">
                                        @error('price')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">{{ trans('labels.original_price') }} </label>
                                        <input type="text" class="form-control numbers_only" name="original_price"
                                            value="{{ $getproductdata->original_price > 0 ? $getproductdata->original_price : 0 }}"
                                            placeholder="{{ trans('labels.original_price') }}" id="original_price">
                                        @error('original_price')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">{{ trans('labels.stock_qty') }} <span
                                                class="text-danger"> * </span></label>
                                        <input type="text" class="form-control numbers_only" name="qty"
                                            value="{{ $getproductdata->qty }}"
                                            placeholder="{{ trans('labels.stock_qty') }}" id="qty">
                                        @error('qty')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">{{ trans('labels.product_low_qty_warning') }} <span
                                                class="text-danger"> * </span></label>
                                        <input type="text" class="form-control numbers_only variation_qty" required
                                            value="{{ $getproductdata->low_qty }}" name="low_qty"
                                            placeholder="{{ trans('labels.product_low_qty_warning') }}">

                                    </div>
                                </div>
                            </div>

                            <div class="@if ($getproductdata->has_variation == 2) dn @endif" id="variations">
                                <div class="col-md-12 px-0">
                                    <div class="form-group">
                                        <label for="attribute" class="col-form-label">{{ trans('labels.attribute') }}
                                            <span class="text-danger">*</span> </label>
                                        <input type="text" class="form-control attribute" name="attribute"
                                            id="attribute" placeholder="{{ trans('labels.enter_attribute') }}"
                                            value="{{ $getproductdata->attribute }}">
                                        @error('attribute')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                @forelse ($getproductdata['multi_variation'] as $ky => $variation)
                                    <div class="row" id="del-{{ $variation->id }}">
                                        <input type="hidden" class="form-control" id="variation_id"
                                            name="variation_id[{{ $ky }}]" value="{{ $variation->id }}">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                @if ($ky == 0)
                                                    <label for="variation"
                                                        class="col-form-label">{{ trans('labels.variation') }} <span
                                                            class="text-danger">*</span> </label>
                                                @endif
                                                <input type="text" class="form-control variation"
                                                    name="variation[{{ $ky }}]"
                                                    placeholder="{{ trans('labels.variation') }}"
                                                    value="{{ $variation->name }}">
                                                @if ($errors->has('variation.' . $ky))
                                                    <span
                                                        class="text-danger">{{ $errors->first('variation.' . $ky) }}</span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                @if ($ky == 0)
                                                    <label for="price"
                                                        class="col-form-label">{{ trans('labels.price') }} <span
                                                            class="text-danger">*</span> </label>
                                                @endif
                                                <input type="text" class="form-control numbers_only variation_price"
                                                    name="variation_price[{{ $ky }}]"
                                                    placeholder="{{ trans('labels.price') }}"
                                                    value="{{ $variation->price }}">
                                                @if ($errors->has('price.' . $ky))
                                                    <span class="text-danger">{{ $errors->first('price.' . $ky) }}</span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                @if ($ky == 0)
                                                    <label for="original_price"
                                                        class="col-form-label">{{ trans('labels.original_price') }} <span
                                                            class="text-danger">*</span> </label>
                                                @endif
                                                <input type="text"
                                                    class="form-control numbers_only variation_original_price"
                                                    name="variation_original_price[{{ $ky }}]"
                                                    placeholder="{{ trans('labels.original_price') }}"
                                                    value="{{ $variation->original_price }}">
                                                @if ($errors->has('original_price.' . $ky))
                                                    <span
                                                        class="text-danger">{{ $errors->first('original_price.' . $ky) }}</span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                @if ($ky == 0)
                                                    <label for="qty"
                                                        class="col-form-label">{{ trans('labels.qty') }} <span
                                                            class="text-danger">*</span> </label>
                                                @endif
                                                <input type="text" class="form-control numbers_only variation_qty"
                                                    name="variation_qty[{{ $ky }}]"
                                                    placeholder="{{ trans('labels.qty') }}"
                                                    value="{{ $variation->qty }}">
                                                @if ($errors->has('qty.' . $ky))
                                                    <span class="text-danger">{{ $errors->first('qty.' . $ky) }}</span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-1 d-flex align-items-end">
                                            <div class="form-group">
                                                <button class="btn btn-danger" type="button"
                                                    onclick="deletedata('{{ URL::to('admin/products/deletevariation-' . $variation->id . '-' . $variation->product_id) }}')"
                                                    {{ count($getproductdata['multi_variation']) == 1 ? 'disabled' : '' }}><i
                                                        class="fa fa-trash" aria-hidden="true"></i> </button>
                                            </div>
                                        </div>
                                    </div>
                                    <span class="hiddencount d-none">{{ $ky }}</span>
                                @empty
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="col-form-label">{{ trans('labels.variation') }}</label>
                                                <input type="text" class="form-control variation" name="variation[]"
                                                    placeholder="{{ trans('labels.variation') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="col-form-label">{{ trans('labels.price') }}</label>
                                                <input type="text" class="form-control numbers_only variation_price"
                                                    name="variation_price[]" placeholder="{{ trans('labels.price') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="col-form-label">{{ trans('labels.original_price') }}</label>
                                                <input type="text"
                                                    class="form-control numbers_only variation_original_price"
                                                    name="variation_original_price[]"
                                                    placeholder="{{ trans('labels.original_price') }}" value="0">
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label class="col-form-label">{{ trans('labels.qty') }}</label>
                                                <input type="text" class="form-control numbers_only variation_qty"
                                                    name="variation_qty[]" placeholder="{{ trans('labels.qty') }}"
                                                    value="0">
                                            </div>
                                        </div>
                                        <div class="col-md-1 d-flex align-items-end">
                                            <div class="form-group">
                                                <button class="btn btn-outline-info" type="button"
                                                    onclick="edititem_fields('{{ trans('labels.variation') }}','{{ trans('labels.price') }}','{{ trans('labels.original_price') }}','{{ trans('labels.qty') }}');">
                                                    <i class="fa-sharp fa-solid fa-plus"></i> </button>
                                            </div>
                                        </div>
                                    </div>
                                @endforelse
                                <div id="edititem_fields"></div>
                            </div>
                            @if (count($getproductdata['multi_variation']) > 0)
                                <button
                                    class="btn btn-outline-info btn-add-variations mb-2 @if ($getproductdata->has_variation == 2) dn @endif"
                                    type="button"
                                    onclick="edititem_fields('{{ trans('labels.variation') }}','{{ trans('labels.price') }}','{{ trans('labels.original_price') }}','{{ trans('labels.qty') }}');">
                                    {{ trans('labels.add_varation') }} <i class="fa-sharp fa-solid fa-plus"></i> </button>
                            @endif
                            <div class="row">

                                <div class="col-sm-12 form-group">
                                    <label class="form-label">{{ trans('labels.description') }}<span class="text-danger">
                                            * </span></label>
                                    <textarea class="form-control" id="ckeditor" name="description" required>{!! $getproductdata->description !!}</textarea>
                                    @error('description')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-sm-12 form-group">
                                    <label class="form-label">{{ trans('labels.additional_info') }}<span
                                            class="text-danger">
                                            * </span></label>
                                    <textarea class="form-control" id="ckeditor1" name="additional_info" required>{!! $getproductdata->additional_info !!}</textarea>
                                    @error('additional_info')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group d-flex justify-content-between">
                                <a href="javascript:void(0)" onclick="addimage('{{ $getproductdata->id }}')"
                                    class="btn btn-secondary">
                                    <i class="fa-regular fa-plus mx-1"></i>{{ trans('labels.add_new') }}
                                </a>
                                <div>
                                    <a href="{{ URL::to('admin/products') }}"
                                        class="btn btn-outline-danger">{{ trans('labels.cancel') }}</a>
                                    <button class="btn btn-secondary"
                                        @if (env('Environment') == 'sendbox') type="button" onclick="myFunction()" @else type="submit" @endif>{{ trans('labels.save') }}</button>
                                </div>
                            </div>
                        </form>
                        <div class="row mt-2">
                            @foreach ($getproductdata['multi_image'] as $key => $productimage)
                                <div class="col-2">
                                    <div class="card-dec">
                                        <img src="{{ helper::image_path($productimage->image) }}"
                                            class="img-fluid product-image rounded-3">
                                        <div class="text-center mt-2">
                                            <a href="javascript:void(0)" class="btn btn-outline-info btn-sm"
                                                onclick="imageview('{{ $productimage->id }}','{{ $productimage->image }}')"><i
                                                    class="fa-regular fa-pen-to-square"></i></a>
                                            <a href="javascript:void(0)"
                                                onclick="statusupdate('{{ URL::to('admin/products/delete_image-' . $productimage->id . '/' . $productimage->product_id) }}')"
                                                class="btn btn-outline-danger btn-sm @if ($getproductdata['multi_image']->count() == 1) d-none @else '' @endif"><i
                                                    class="fa-regular fa-trash"></i></a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        @include('admin.layout.no_data')
                    @endif
                </div>
            </div>
            @if (App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first() != null &&
                    App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first()->activated == 1)
                @if (helper::appdata($vendor_id)->checkout_login_required == 1)
                    <div class="card border-0 mt-3 box-shadow">
                        <div class="card-body">
                            <h5 class="text-uppercase">{{ trans('labels.product_reviews') }}</h5>
                            <div class="table-responsive">
                                <table
                                    class="table table-striped table-bordered py-3 zero-configuration w-100 dataTable no-footer">
                                    <thead>
                                        <tr class="text-uppercase fw-500">
                                            <td>{{ trans('labels.srno') }}</td>
                                            <td>{{ trans('labels.image') }}</td>
                                            <td>{{ trans('labels.name') }}</td>
                                            <td>{{ trans('labels.description') }}</td>
                                            <td>{{ trans('labels.ratting') }}</td>
                                            <td>{{ trans('labels.action') }}</td>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $i = 1;
                                        @endphp
                                        @foreach ($productreview as $item)
                                            <tr class="fs-7 row1" id="dataid{{ $item->id }}"
                                                data-id="{{ $item->id }}">
                                                <td>@php
                                                    echo $i++;
                                                @endphp</td>
                                                <td>
                                                    <img src="{{ @helper::image_path($item->image) }}"
                                                        class="img-fluid rounded hw-50" alt="">
                                                </td>
                                                <td>{{ $item->name }}</td>
                                                <td>{{ $item->description }}</td>
                                                <td>{{ $item->star }} </td>
                                                <td>
                                                    <a href="javascript:void(0)"
                                                        @if (env('Environment') == 'sendbox') onclick="myFunction()" @else
                                                        onclick="statusupdate('{{ URL::to('/admin/products/review/delete-' . $item->id) }}')" @endif
                                                        class="btn btn-outline-danger btn-sm {{ Auth::user()->type == 4 ? (helper::check_access('role_products', Auth::user()->role_id, Auth::user()->vendor_id, 'edit') == 1 ? '' : 'd-none') : '' }}">
                                                        <i class="fa-regular fa-trash"></i></a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                @endif
            @endif
        </div>
    </div>

    {{-- add Modal --}}
    <div class="modal modal-fade-transform" id="addModal" tabindex="-1" aria-labelledby="addModallable"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addModallable">{{ trans('labels.image') }} <span class="text-danger"> *
                        </span></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action=" {{ URL::to('admin/products/add_image') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <input type="hidden" id="product_id" name="product_id">
                        <input type="file" name="image" class="form-control" id="">
                        @error('image')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-secondary">{{ trans('labels.save') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- edit Modal --}}
    <div class="modal modal-fade-transform" id="editModal" tabindex="-1" aria-labelledby="editModallable"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editModallable">{{ trans('labels.image') }} (450 x 300) <span
                            class="text-danger"> * </span></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action=" {{ URL::to('admin/products/update') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <input type="hidden" id="img_id" name="id">
                        <input type="hidden" id="img_name" name="image">
                        <input type="file" name="product_image" class="form-control" id="">
                        @error('product_image')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-secondary">{{ trans('labels.save') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/ckeditor/4.12.1/ckeditor.js"></script>
    <script>
        CKEDITOR.replace('ckeditor1');
    </script>
    <script src="{{ url(env('ASSETPATHURL') . 'admin-assets/js/editor.js') }}"></script>
    <script src="{{ url(env('ASSETPATHURL') . 'admin-assets/js/product.js') }}"></script>
@endsection
