@extends('web.layout.default')
@section('contents')
    <!-- BREADCRUMB AREA START -->
    <section class="py-5 mb-5 bg-light">
        <div class="container">
            <nav aria-label="breadcrumb">
                <h2 class="breadcrumb-title mb-2">{{ trans('labels.checkout') }}</h2>
                <ol class="breadcrumb justify-content-center">
                    <li class="{{ session()->get('direction') == 2 ? 'breadcrumb-item-rtl' : 'breadcrumb-item' }}">
                        <a class="text-dark" href="{{ URL::to(@$vendordata->slug . '/') }}">{{ trans('labels.home') }}</a>
                    </li>
                    <li class="{{ session()->get('direction') == 2 ? 'breadcrumb-item-rtl' : 'breadcrumb-item' }}">
                        <a class="text-dark" href="{{ URL::to(@$vendordata->slug . '/cart') }}">{{ trans('labels.cart') }}</a>
                    </li>
                    <li class="text-muted {{ session()->get('direction') == 2 ? 'breadcrumb-item-rtl' : 'breadcrumb-item' }} active"
                        aria-current="page">{{ trans('labels.checkout') }}</li>
                </ol>
            </nav>
        </div>
    </section>
    <!-- BREADCRUMB AREA END -->
    <!-- CHECKOUT AREA START -->
    <section class="checkout">
        <div class="container">
            @if (count($getcartlist) > 0)
                <div class="row">
                    <div class="col-lg-8 col-auto">
                        <div class="card bg-light border-0 mb-3">
                            <div class="card-body">
                                <div class="personal-info bg-light p-2 mb-3">
                                    <h5 class="text-primary border-bottom pb-2 mb-3"> <i
                                            class="fa-regular fa-user"></i>
                                            <span class="mx-2">{{ trans('labels.personal_info') }}</span>
                                        </h5>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="user_name"
                                                    class="form-label">{{ trans('labels.name') }}</label>
                                                <input type="text" class="form-control input-h rounded-0" id="user_name"
                                                    name="user_name" placeholder="{{ trans('labels.name') }}" value="{{Auth::user() && Auth::user()->type == 3 ? Auth::user()->name : ''}}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="user_email"
                                                    class="form-label">{{ trans('labels.email') }}</label>
                                                <input type="email" class="form-control input-h rounded-0" id="user_email"
                                                    name="user_email" placeholder="{{ trans('labels.email') }}" value="{{Auth::user() && Auth::user()->type == 3 ? Auth::user()->email : ''}}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="user_mobile"
                                                    class="form-label">{{ trans('labels.mobile') }}</label>
                                                <input type="text" class="form-control input-h rounded-0 numbers_only"
                                                    id="user_mobile" name="user_mobile"
                                                    placeholder="{{ trans('labels.mobile') }}" value="{{Auth::user() && Auth::user()->type == 3 ? Auth::user()->mobile : ''}}">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="billing-info bg-light p-2 mb-3">
                                    <h5 class="text-primary border-bottom py-2 mb-3"> <i
                                            class="fa-regular fa-file-lines"></i>
                                            <span class="mx-2">{{ trans('labels.billing_address') }}</span>
                                        </h5>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="billing_address"
                                                    class="form-label">{{ trans('labels.address') }}</label>
                                                <input type="text" class="form-control input-h rounded-0" id="billing_address"
                                                    name="billing_address" placeholder="{{ trans('labels.address') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="billing_landmark"
                                                    class="form-label">{{ trans('labels.landmark') }}</label>
                                                <input type="text" class="form-control input-h rounded-0" id="billing_landmark"
                                                    name="billing_landmark" placeholder="{{ trans('labels.landmark') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="billing_postal_code"
                                                    class="form-label">{{ trans('labels.postalcode') }}</label>
                                                <input type="text" class="form-control input-h rounded-0" id="billing_postal_code"
                                                    name="billing_postal_code"
                                                    placeholder="{{ trans('labels.postalcode') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="billing_city"
                                                    class="form-label">{{ trans('labels.city') }}</label>
                                                <input type="text" class="form-control input-h rounded-0" id="billing_city"
                                                    name="billing_city" placeholder="{{ trans('labels.city') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="billing_state"
                                                    class="form-label">{{ trans('labels.state') }}</label>
                                                <input type="text" class="form-control input-h rounded-0" id="billing_state"
                                                    name="billing_state" placeholder="{{ trans('labels.state') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="billing_country"
                                                    class="form-label">{{ trans('labels.country') }}</label>
                                                <input type="text" class="form-control input-h rounded-0" id="billing_country"
                                                    name="billing_country" placeholder="{{ trans('labels.country') }}">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="shipping-info bg-light p-2 mb-3">
                                    <div class="row justify-content-between border-bottom gx-0 pb-2 mb-2">
                                        <h5 class="text-primary col-auto mb-2 mb-sm-0"> <i
                                                class="fa-regular fa-truck-fast"></i>
                                                <span class="mx-2">{{ trans('labels.shipping_address') }}</span>
                                        </h5>
                                        <div class="sam_address d-flex align-items-center col-auto">
                                            <input type="checkbox" name="" id="same" class="mx-1"
                                                onclick="copy_billing_data()">
                                            <label for="same" class="fs-7 text-secondary">{{trans('labels.same_As_billing_address')}}</label>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="shipping_address"
                                                    class="form-label">{{ trans('labels.address') }}</label>
                                                <input type="text" class="form-control input-h rounded-0" id="shipping_address"
                                                    name="shipping_address" placeholder="{{ trans('labels.address') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="shipping_landmark"
                                                    class="form-label">{{ trans('labels.landmark') }}</label>
                                                <input type="text" class="form-control input-h rounded-0" id="shipping_landmark"
                                                    name="shipping_landmark"
                                                    placeholder="{{ trans('labels.landmark') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="shipping_postal_code"
                                                    class="form-label">{{ trans('labels.postalcode') }}</label>
                                                <input type="text" class="form-control input-h rounded-0"
                                                    id="shipping_postal_code" name="shipping_postal_code"
                                                    placeholder="{{ trans('labels.postalcode') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="shipping_city"
                                                    class="form-label">{{ trans('labels.city') }}</label>
                                                <input type="text" class="form-control input-h rounded-0" id="shipping_city"
                                                    name="shipping_city" placeholder="{{ trans('labels.city') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="shipping_state"
                                                    class="form-label">{{ trans('labels.state') }}</label>
                                                <input type="text" class="form-control input-h rounded-0" id="shipping_state"
                                                    name="shipping_state" placeholder="{{ trans('labels.state') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="shipping_country"
                                                    class="form-label">{{ trans('labels.country') }}</label>
                                                <input type="text" class="form-control input-h rounded-0" id="shipping_country"
                                                    name="shipping_country" placeholder="{{ trans('labels.country') }}">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-auto">
                        <div class="shipping-area-info bg-light card border-0 rounded-0 mb-3 p-2">
                            <div class="card-body">
                                <p class="fs-5 text-dark fw-600 pb-2 mb-3 border-bottom">
                                    {{ trans('labels.shipping_area') }}</p>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group mb-0">
                                            <select class="form-select rounded-0" name="shipping_area" id="shipping_area">
                                                <option value="" selected disabled> {{ trans('labels.select') }}
                                                </option>
                                                @forelse ($getshippingarealist as $shippingarea)
                                                    <option value="{{ $shippingarea->id }}"
                                                        data-delivery-charge="{{ $shippingarea->delivery_charge }}"
                                                        data-area-name="{{ $shippingarea->name }}">
                                                        {{ $shippingarea->name }}
                                                        @if ($shippingarea->delivery_charge > 0)
                                                            {{ trans('labels.delivery_charge') }} :
                                                            {{ helper::currency_formate($shippingarea->delivery_charge, @$vendordata->id) }}
                                                        @else
                                                            {{ trans('labels.free_delivery') }}
                                                        @endif
                                                    </option>
                                                @empty
                                                    <option value="" selected disabled>
                                                        {{ trans('labels.nodata_found') }} </option>
                                                @endforelse
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card bg-light bg-light border-0 rounded-0 mb-3 p-2">
                            <div class="card-body">
                                <p class="fs-5 text-dark fw-600 pb-2 mb-3 border-bottom">{{ trans('labels.summary') }}</p>
                                <ul class="list-group list-group-flush">
                                    @php
                                        $sub_total = 0;
                                        $tax_amount = 0;
                                    @endphp
                                    @foreach ($getcartlist as $cartdata)
                                        @php
                                            
                                            $sub_total += $cartdata->product_price * $cartdata->qty;
                                            
                                            $tax_amount += $cartdata->product_tax * $cartdata->qty;
                                            
                                        @endphp
                                    @endforeach
                                    @php
                                        
                                        $offer_amount = 0;
                                        
                                        $offer_code = '';
                                        
                                        if (session()->has('discount_data')) {
                                            $offer_amount = session()->get('discount_data')['offer_amount'];
                                        
                                            $offer_code = session()->get('discount_data')['offer_code'];
                                        }
                                        
                                        $grand_total = $sub_total - $offer_amount + $tax_amount;
                                        
                                    @endphp
                                    <li class="list-group-item d-flex align-items-center border-0 px-0 justify-content-between bg-light">
                                        <span>{{ trans('labels.sub_total') }}</span>
                                        <span>{{ helper::currency_formate($sub_total, @$vendordata->id) }}</span>
                                    </li>
                                    @if (session()->has('discount_data'))
                                        <li class="list-group-item d-flex align-items-center border-0 px-0 justify-content-between bg-light">
                                            <span>{{ trans('labels.discount') }}
                                                {{ '(' . session()->get('discount_data')['offer_code'] . ')' }} </span>
                                            <span class="text-danger">- {{ helper::currency_formate($offer_amount, @$vendordata->id) }}</span>
                                        </li>
                                    @endif
                                    <li class="list-group-item d-flex align-items-center border-0 px-0 justify-content-between bg-light">
                                        <span>{{ trans('labels.tax') }}</span>
                                        <span>{{ helper::currency_formate($tax_amount, @$vendordata->id) }}</span>
                                    </li>
                                    <li
                                        class="list-group-item d-flex align-items-center border-0 px-0 justify-content-between bg-light delivery-charge-section d-none">
                                        <span>{{ trans('labels.delivery_charge') }}</span>
                                        <span class="delivery_charge"></span>
                                    </li>
                                    <li class="list-group-item d-flex bg-light px-0 border-0 border-top-dashed align-items-center justify-content-between">
                                        <strong
                                            class="text-success fw-semibold">{{ trans('labels.grand_total') }}</strong>
                                        <strong
                                            class="grand_total text-success fw-semibold">{{ helper::currency_formate($grand_total, @$vendordata->id) }}</strong>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="shipping-area-info bg-light card border-0 rounded-0 mb-3 p-2">
                            <div class="card-body">
                                <p class="fs-5 text-dark fw-600 pb-2 mb-3 border-bottom">{{ trans('labels.order_notes') }}
                                </p>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <textarea class="form-control rounded-0" name="order_notes" id="order_notes" rows="3"
                                                placeholder="{{ trans('labels.order_notes') }} {{ trans('labels.optional') }} "></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card bg-light border-0 rounded-0 mb-3 p-2">
                            <div class="card-body">
                                <h5 class="text-primary border-bottom fw-600 pb-2 mb-3">
                                    {{ trans('labels.choose_payment_method') }}
                                </h5>
                                <div class="payment-option">
                                    <div class="row gx-0 justify-content-between">
                                        @forelse ($getpaymentmethodslist as $key => $pmdata)
                                            @php
                                                $transaction_type = $pmdata->payment_type;
                                            @endphp
                                            <label class="form-check-label col-md-6 col-6 px-1"
                                                for="payment{{ $transaction_type }}">
                                                <input class="form-check-input" type="radio" name="transaction_type"
                                                    id="payment{{ $transaction_type }}"
                                                    data-payment-type="{{ $transaction_type }}"
                                                    value="{{ $transaction_type }}"
                                                    data-currency="{{ $pmdata->currency }}" 
                                                    @if ($transaction_type == '6') data-bank-name="{{ $pmdata->bank_name }}"  data-account-holder-name="{{ $pmdata->account_holder_name }}"  data-account-number="{{ $pmdata->account_number }}" data-bank-ifsc-code="{{ $pmdata->bank_ifsc_code }}" @endif
                                                    {{ $key == 0 ? 'checked' : '' }}>
                                                <div
                                                    class="{{ @helper::appdata(@$vendordata->id)->web_layout == 2 ? 'payment-gateway-rtl' : 'payment-gateway' }} mt-2 mb-0 rounded-0 justify-content-center w-100">
                                                    <span class="text-center"><img
                                                            src="{{ helper::image_path($pmdata->image) }}" class="mx-2"
                                                            alt="">{{ ucfirst($pmdata->payment_name) }}</span>
                                                    {{-- @if ($transaction_type == 2)
                                                        <span class="text-end text-muted"></span>
                                                    @endif --}}
                                                    @if (in_array($transaction_type, ['2', '3', '4', '5', '8', '9', '10']))
                                                        @if ($transaction_type == '2')
                                                            <input type="hidden" name="razorpaykey" id="razorpaykey"
                                                                value="{{ $pmdata->public_key }}">
                                                        @endif
                                                        @if ($transaction_type == '3')
                                                            <input type="hidden" name="stripekey" id="stripekey"
                                                                value="{{ $pmdata->public_key }}">
                                                        @endif
                                                        @if ($transaction_type == '4')
                                                            <input type="hidden" name="flutterwavekey"
                                                                id="flutterwavekey" value="{{ $pmdata->public_key }}">
                                                        @endif
                                                        @if ($transaction_type == '5')
                                                            <input type="hidden" name="paystackkey" id="paystackkey"
                                                                value="{{ $pmdata->public_key }}">
                                                        @endif
                                                    @endif
                                                </div>
                                                {{-- @if ($transaction_type == 2)
                                                    <small
                                                        class="walleterror text-danger d-none">{{ trans('messages.insufficient_wallet') }}</small>
                                                @endif --}}
                                            </label>
                                            @if ($transaction_type == '3')
                                                <div class="my-3 d-none" id="card-element"></div>
                                            @endif
                                        @empty
                                            @include('web.nodata')
                                        @endforelse
                                        @if (!in_array('3', array_column($getpaymentmethodslist->toArray(), 'payment_type')))
                                            <input type="hidden" name="stripekey" id="stripekey" value="">
                                        @endif
                                    </div>
                                    <div class="text-center">
                                        <button type="submit" class="btn btn-fashion w-100 mt-4"
                                            onclick="placeorder()">{{ trans('labels.proceed_pay') }}</button>
                                        @if (env('Environment') == 'sendbox')
                                            <button type="button" class="btn btn-fashion w-100 mt-4"
                                                onclick="randomdata()">{{ trans('labels.data') }}</button>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <input type="hidden" name="grand_total" id="grand_total" value="{{ $grand_total }}">
                <input type="hidden" name="sub_total" id="sub_total" value="{{ $sub_total }}">
                <input type="hidden" name="offer_code" id="offer_code" value="{{ $offer_code }}">
                <input type="hidden" name="offer_amount" id="offer_amount" value="{{ $offer_amount }}">
                <input type="hidden" name="tax_amount" id="tax_amount" value="{{ $tax_amount }}">
                <input type="hidden" name="delivery_charge" id="delivery_charge" value="0">
                <input type="hidden" name="vendor_id" id="vendor_id" value="{{ $vendordata->id }}">
            @else
                @include('web.nodata')
            @endif
        </div>
    </section>
    <!-- CHECKOUT AREA END -->
    <div class="modal fade" id="modalbankdetails" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
        aria-labelledby="modalbankdetailsLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalbankdetailsLabel">{{ trans('labels.banktransfer') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form enctype="multipart/form-data" action="{{ URL::to($vendordata->slug.'/checkout/placeorder') }}" method="POST">
                    <div class="modal-body">
                        @csrf
                        <input type="hidden"   name="modal_vendor_slug" id="modal_vendor_slug" class="form-control" value="">
                        <input type="hidden" name="modal_user_name" id="modal_user_name" class="form-control" value="">
                        <input type="hidden" name="modal_user_email" id="modal_user_email" class="form-control" value="">
                        <input type="hidden" name="modal_user_mobile" id="modal_user_mobile" class="form-control" value="">
                        <input type="hidden" name="modal_billing_address" id="modal_billing_address" class="form-control" value="">
                        <input type="hidden" name="modal_billing_landmark" id="modal_billing_landmark" class="form-control" value="">
                        <input type="hidden" name="modal_billing_postal_code" id="modal_billing_postal_code" class="form-control" value="">
                        <input type="hidden" name="modal_billing_city" id="modal_billing_city" class="form-control" value="">
                        <input type="hidden" name="modal_billing_state" id="modal_billing_state" class="form-control" value="">
                        <input type="hidden" name="modal_billing_country" id="modal_billing_country" class="form-control" value="">
                        <input type="hidden" name="modal_shipping_address" id="modal_shipping_address" class="form-control" value="">
                        <input type="hidden" name="modal_shipping_landmark" id="modal_shipping_landmark" class="form-control" value="">
                        <input type="hidden" name="modal_postal_code" id="modal_postal_code" class="form-control" value="">
                        <input type="hidden" name="modal_shipping_city" id="modal_shipping_city" class="form-control" value="">
                        <input type="hidden" name="modal_shipping_state" id="modal_shipping_state" class="form-control" value="">
                        <input type="hidden" name="modal_shipping_country" id="modal_shipping_country" class="form-control" value="">
                        <input type="hidden" name="modal_shipping_area" id="modal_shipping_area" class="form-control" value="">
                        <input type="hidden" name="modal_delivery_charge" id="modal_delivery_charge" class="form-control" value="">
                        <input type="hidden" name="modal_grand_total" id="modal_grand_total" class="form-control" value="">
                        <input type="hidden" name="modal_sub_total" id="modal_sub_total" class="form-control" value="">
                        <input type="hidden" name="modal_tax" id="modal_tax" class="form-control" value="">
                        <input type="hidden" name="modal_notes" id="modal_notes" class="form-control" value="">
                        <input type="hidden" name="modal_offer_code" id="modal_offer_code" class="form-control" value="">
                        <input type="hidden" name="modal_offer_amount" id="modal_offer_amount" class="form-control" value="">
                        <input type="hidden" name="modal_transaction_type" id="modal_transaction_type" class="form-control" value="">
                       
                        <p> {{ trans('labels.bank_name') }} : <span class="data-bank-name"></span></p>
                        <p> {{ trans('labels.account_holder_name') }} : <span class="data-account-holder-name"></span>
                        </p>
                        <p> {{ trans('labels.account_number') }} : <span class="data-account-number"></span></p>
                        <p> {{ trans('labels.bank_ifsc_code') }} : <span class="data-bank-ifsc-code"></span></p>
                        <hr>
                        <div class="form-group col-md-12">
                            <label for="screenshot"> {{ trans('labels.screenshot') }} </label>
                            <div class="controls">
                                <input type="file" name="screenshot" id="screenshot"
                                    class="form-control  @error('screenshot') is-invalid @enderror" required>
                                @error('screenshot')
                                    <span class="text-danger"> {{ $message }} </span>
                                @enderror
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-danger"
                            data-bs-dismiss="modal">{{ trans('labels.close') }}</button>
                        <button @if (env('Environment') == 'sendbox') type="button" onclick="myFunction()" type="submit" @endif
                            class="btn btn-primary"> {{ trans('labels.save') }} </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script src="https://checkout.stripe.com/v2/checkout.js"></script>
    <script src="https://js.stripe.com/v3/"></script>
    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
    <script src="https://checkout.flutterwave.com/v3.js"></script>
    <script src="https://js.paystack.co/v1/inline.js"></script>
    <script>
        let title = {{ Js::from(helper::appdata(@$vendordata->id)->web_title) }}
        let description = "Order Payment";
        let env = {{ Js::from(env('Environment')) }};
        let successurl = "{{ URL::to($vendordata->slug) }}/checkout/placeorder/success/";
        let orderlimit_url = "{{ URL::to($vendordata->slug) . '/checkout/orderlimit' }}";
        let failure = "{{ url()->current() }}";
        var vendorslug = "{{$vendordata->slug}}";
        var ordersuccess = "{{ URL::to($vendordata->slug.'/orders-success-')}}";
    </script>
    <script src="{{ url(env('ASSETPATHURL') . 'web-assets/js/checkout.js') }}"></script>
@endsection
