@extends('web.layout.default')
@section('contents')

    <!-- BREADCRUMB AREA START -->
    <section class="py-5 mb-5 bg-light">
        <div class="container">
            <nav aria-label="breadcrumb">

                <h2 class="breadcrumb-title mb-2">{{ trans('labels.product_details') }}</h2>

                <ol class="breadcrumb justify-content-center">
                    <li class="{{ session()->get('direction') == 2 ? 'breadcrumb-item-rtl' : 'breadcrumb-item' }}">
                        <a class="text-dark " href="{{ URL::to(@$vendordata->slug . '/') }}">{{ trans('labels.home') }}</a>
                    </li>
                    @if (!empty($productdata))
                        <li class="{{ session()->get('direction') == 2 ? 'breadcrumb-item-rtl' : 'breadcrumb-item' }}">
                            <a class="text-dark"
                                href="{{ URL::to(@$vendordata->slug . '/categories-' . $productdata['category_info']->slug) }}">{{ $productdata['category_info']->name }}</a>
                        </li>
                        @if (!empty($productdata['subcategory_info']))
                            <li class="{{ session()->get('direction') == 2 ? 'breadcrumb-item-rtl' : 'breadcrumb-item' }}">
                                <a class="text-dark "
                                    href="{{ URL::to(@$vendordata->slug . '/categories-' . $productdata['category_info']->slug . '/subcategory-' . $productdata['subcategory_info']->slug) }}">{{ $productdata['subcategory_info']->name }}</a>
                            </li>
                        @endif
                        <li class="text-muted {{ session()->get('direction') == 2 ? 'breadcrumb-item-rtl' : 'breadcrumb-item' }} active"
                            aria-current="page">{{ $productdata->name }}</li>
                    @endif
                </ol>
            </nav>
        </div>
    </section>
    <!-- BREADCRUMB AREA END -->
    @if (!empty($productdata))
        @php
            if (request()->has('type') && request()->get('type') == 1) {
                if (@helper::top_deals($vendordata->id)->offer_type == 1) {
                    $price = $productdata->price - @helper::top_deals($vendordata->id)->offer_amount;
                } else {
                    $price = $productdata->price - $productdata->price * (@helper::top_deals($vendordata->id)->offer_amount / 100);
                }
                $original_price = $productdata->price;
            } else {
                $price = $productdata->price;
                $original_price = $productdata->original_price;
            }
            $tax_amount = ($price * $productdata->tax) / 100;
            $off = $original_price > 0 ? number_format(100 - ($price * 100) / $original_price, 1) : 0;
        @endphp
        <!-- PRODUCTS VIEW AREA START -->
        <section class="product-view pt-5">
            <div class="container">
                <div class="row justify-content-between mb-md-4">

                    <div class="col-md-5 mb-5">
                        <div class="card h-100 overflow-hidden rounded-0 border-0 position-relative">
                            <!-- new big-view -->
                            <div class="sp-loading"><img src="https://via.placeholder.com/1100x1220" alt=""><br>LOADING IMAGES</div>
                            <div class="sp-wrap">
                                @foreach ($productdata['multi_image'] as $key => $image)
                                <a href="{{ $image->image_url }}"><img src="{{ $image->image_url }}" alt=""></a>
                                @endforeach
                            </div>
                            <!-- new big-view -->
                        </div>
                    </div>
                    <div class="col-md-6 mb-4">
                        <div class="product-content px-md-0">

                            <div class="d-flex align-items-center justify-content-between">
                                <h2 class="text-dark product-title line-2">{{ $productdata->name }}</h2>
                            </div>
                            <!-- rating star section Start -->
                            @if (App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first() != null &&
                                    App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first()->activated == 1)
                                @if (helper::appdata($vendordata->id)->checkout_login_required == 1)
                                    <div class="d-flex">
                                        <p class="fs-7"><i
                                                class="text-warning fa-solid fa-star {{ session()->get('direction') == 2 ? 'ps-1' : 'pe-1' }}"></i><span
                                                class="text-dark fw-500">{{ number_format($averagerating, 1) }}</span></p>
                                        <span class="px-2 d-inline-block text-dark fw-500">({{ $totalreview }}
                                            {{ trans('labels.reviews') }})</span>
                                    </div>
                                @endif
                            @endif

                            <!-- rating star section End -->
                            <p class="pt-2">
                                <span class="product-price text-truncate">
                                    {{ helper::currency_formate($price, $productdata->vendor_id) }} </span>
                                <del
                                    class="text-muted fs-7 product-original-price">{{ helper::currency_formate($original_price, $productdata->vendor_id) }}</del>
                                @if ($off != 0)
                                    <span class="text-secondary product-price-off-box px-2 text-truncate">(<span
                                            class="price-off">-{{ $off }}</span>% {{ trans('labels.off') }})
                                    </span>
                                @endif

                            </p>
                            <p>
                                @if ($productdata->tax > 0)
                                    <span class="text-danger text-truncate">{{ $productdata->tax }}%
                                        {{ trans('labels.additional_tax') }}</span>
                                @else
                                    <span class="text-success text-truncate">{{ trans('labels.inclusive_all_tax') }}</span>
                                @endif
                            </p>



                            @if ($productdata->has_variation == 1)
                                <p class="text-primary my-2 text-truncate"> {{ ucfirst($productdata->attribute) }} :
                                    <span class="product-variation fw-600"></span>
                                </p>
                            @endif

                            @if (!empty($productdata->description))
                                <div class="row my-3">
                                    <p class="text-primary fw-semibold mb-1 text-truncate">
                                        {{ trans('labels.product_details') }}
                                    </p>
                                    <div class="col-lg-12 product-description-limit">
                                        {!! $productdata->description !!}<a class="fw-bold text-decoration-underline"
                                            href="#pills-tab" id="readmore"
                                            onclick="$('#pills-tab a:first').tab('show');">{{ trans('labels.readmore') }}</a>
                                    </div>
                                </div>
                            @endif

                            @if ($productdata->has_variation == 1)
                                <div class="product-variations-wrapper">
                                    <div class="size-variation">
                                        <p class="text-primary fw-bold"> {{ trans('labels.select_attribute') }}
                                            {{ ucfirst($productdata->attribute) }} : </p>
                                        <ul class="d-flex align-items-center py-2">
                                            @foreach ($productdata->multi_variation as $key => $variation)
                                                @php
                                                    if (request()->has('type') && request()->get('type') == 1) {
                                                        if (@helper::top_deals($vendordata->id)->offer_type == 1) {
                                                            $variation_price = $variation->price - @helper::top_deals($vendordata->id)->offer_amount;
                                                        } else {
                                                            $variation_price = $variation->price - $variation->price * (@helper::top_deals($vendordata->id)->offer_amount / 100);
                                                        }
                                                        $variation_original_price = $variation->price;
                                                    } else {
                                                        $variation_price = $variation->price;
                                                        $variation_original_price = $variation->original_price;
                                                    }
                                                    $tax_amount = ($price * $productdata->tax) / 100;
                                                    $off = $original_price > 0 ? number_format(100 - ($price * 100) / $original_price, 1) : 0;
                                                @endphp
                                                <li class="me-2">
                                                    <input type="radio" id="size_{{ $key }}" name="size"
                                                        value="{{ ucfirst($variation->name) }}" class="d-none"
                                                        {{ $key == 0 ? 'checked' : '' }}
                                                        data-price="{{ $variation_price }}"
                                                        data-original-price="{{ $variation_original_price }}"
                                                        data-id="{{ $variation->id }}">
                                                    <label
                                                        for="size_{{ $key }}">{{ ucfirst($variation->name) }}</label>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            @endif


                            <div class="row align-items-center justify-content-between mt-4">
                                <div class="col-lg-6 col-md-6 col-12 mb-3 mb-md-0">
                                    <a type="button" class="btn py-2 btn-secondary rounded-0 w-100" href="javascript:void(0)"
                                        onclick="addtocart('{{ $productdata->id }}','{{ $productdata->slug }}','{{ $productdata->name }}','{{ $productdata['product_image']->image }}','{{ $tax_amount }}','{{ $price }}','{{ ucfirst($productdata->attribute) }}','{{ URL::to(@$vendordata->slug . '/cart/add') }}')">{{ trans('labels.add_to_cart') }}</a>
                                </div>
                                @if (App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first() != null &&
                                        App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first()->activated == 1)
                                    @if (helper::appdata($vendordata->id)->checkout_login_required == 1)
                                        @if (Auth::user() && Auth::user()->type == 3)
                                            @php
                                                $favorite = helper::ceckfavorite($productdata->id, $vendordata->id, Auth::user()->id);
                                            @endphp
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <a class="btn py-2 btn-primary rounded-0 w-100"
                                                    onclick="managefavorite('{{ $productdata->id }}',{{ $vendordata->id }},'{{ URL::to(@$vendordata->slug . '/managefavorite') }}')"
                                                    href="javascript:void(0)">
                                                    @if (!empty($favorite) && $favorite->count() > 0)
                                                        {{ trans('labels.remove_to_wishlist') }}
                                                    @else
                                                        {{ trans('labels.add_to_wishlist') }}
                                                    @endif
                                                </a>
                                            </div>
                                        @endif
                                    @endif
                                @endif
                            </div>


                        </div>
                    </div>
                </div>

                <!-- description section start-->
                <ul class="nav nav-pills pb-4 mb-4 border-bottom" id="pills-tab" role="tablist">

                    <li class="nav-item" role="presentation">
                        <a class="nav-link mb-3 mb-md-0 active {{ session()->get('direction') == 2 ? 'ms-3 ms-md-4' : 'me-3 me-md-4' }}"
                            aria-current="page" data-bs-toggle="pill" data-bs-target="#pills-description"
                            href="javascript:void(0)">{{ trans('labels.description') }}</a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link  {{ session()->get('direction') == 2 ? 'ms-3 ms-md-4' : 'me-3 me-md-4' }}"
                            href="javascript:void(0)" data-bs-toggle="pill"
                            data-bs-target="#pills-additional_info">{{ trans('labels.additional_info') }}</a>
                    </li>
                    @if (App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first() != null &&
                            App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first()->activated == 1)
                        @if (helper::appdata($vendordata->id)->checkout_login_required == 1)
                            <li class="nav-item" role="presentation">
                                <a class="nav-link" href="javascript:void(0)" data-bs-toggle="pill"
                                    data-bs-target="#pills-review">{{ trans('labels.reviews') }}</a>
                            </li>
                        @endif
                    @endif
                </ul>
                <div class="tab-content" id="pills-tabContent">

                    <div class="tab-pane fade" id="pills-additional_info" role="tabpanel"
                        aria-labelledby="pills-additional_info-tab">{!! $productdata->additional_info !!}</div>

                    <div class="tab-pane fade active show" id="pills-description" role="tabpanel"
                        aria-labelledby="pills-description-tab">{!! $productdata->description !!}</div>
                    @if (App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first() != null &&
                            App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first()->activated == 1)
                        @if (helper::appdata($vendordata->id)->checkout_login_required == 1)
                            <div class="tab-pane fade" id="pills-review" role="tabpanel"
                                aria-labelledby="pills-review-tab">
                                <div class="row gy-4 gy-md-5 g-4 g-xxl-5">
                                    <div class="col-md-12 col-lg-5 col-xxl-7 order-2 order-md-1">
                                        @if(count($review) > 0)
                                            @foreach ($review as $review)
                                                <!-- review and rating -->
                                                <div class="d-md-flex my-4 border-bottom">
                                                    <!-- review avatar -->
                                                    <div class="avatar avatar-lg me-md-3 mb-3 flex-shrink-0">
                                                        <img class="avatar-img rounded-circle"
                                                            src="{{ helper::image_path($review->image) }}" alt="avatar">
                                                    </div>
                                                    <!-- review avatar -->

                                                    <!-- review-content -->
                                                    <div class="review-content w-100">
                                                        <div class="d-flex justify-content-between mb-2">
                                                            <div>
                                                                <h6 class="me-3 mb-0 fw-bold text-dark text-truncate">
                                                                    {{ $review->name }}
                                                                </h6>
                                                                <!-- Info -->
                                                                <p class="text-muted fs-7 text-truncate">
                                                                    {{ helper::date_formate($review->created_at) }}</p>
                                                            </div>
                                                            <!-- Review star -->
                                                            <p class="icon-md rounded text-bg-warning d-flex px-2 fs-7"><i
                                                                    class="fas fa-star fa-fw text-dark me-2"></i>{{ number_format($review->star, 1) }}
                                                            </p>
                                                        </div>

                                                        <p class="mb-3 text-muted fs-7 fw-normal line-2">
                                                            {{ $review->description }}
                                                        </p>
                                                    </div>
                                                    <!-- review-content -->
                                                </div>
                                            @endforeach
                                        @else
                                            @include('web.nodata')
                                        @endif
                                    </div>

                                    <div class="col-md-12 col-lg-7 col-xxl-5">
                                        <div class="card-body pt-4 p-0 sticky">
                                            <!-- Customer Review -->
                                            <h4 class="heading mb-3 text-dark text-truncate">
                                                {{ trans('labels.customer_review') }}
                                            </h4>
                                            <div class="card border-0 bg-light p-4 mb-4">
                                                <div class="row g-4 align-items-center">
                                                    <!-- Rating info -->
                                                    <div class="col-md-4">
                                                        <div class="text-center">
                                                            <!-- Info -->
                                                            <h2 class="mb-0 fw-bold text-dark">
                                                                {{ number_format($averagerating, 1) }}</h2>
                                                            <p class="mb-2 text-muted">{{ trans('labels.based_on') }}
                                                                {{ $totalreview }} {{ trans('labels.reviews') }}</p>
                                                            <!-- Star -->
                                                            @php
                                                                $exploderatting = explode('.', number_format($averagerating, 1));
                                                                $count = 5;
                                                            @endphp
                                                            <ul class="list-inline mb-0">
                                                                @for ($i = 0; $i < $exploderatting[0]; $i++)
                                                                    <li class="list-inline-item me-0 small"><i
                                                                            class="fa-solid fa-star text-warning"></i>
                                                                    </li>
                                                                    @php
                                                                        $count--;
                                                                    @endphp
                                                                    @if ($i == $exploderatting[0] - 1)
                                                                        @if ($exploderatting[1] != 0)
                                                                            <li class="list-inline-item me-0"><i
                                                                                    class="fa-solid fa-star-half-alt text-warning"></i>
                                                                            </li>
                                                                            @php
                                                                                $count--;
                                                                            @endphp
                                                                        @endif
                                                                    @endif
                                                                @endfor
                                                                @for ($i = 0; $i < $count; $i++)
                                                                    <li class="list-inline-item me-0 small"><i
                                                                            class="fa-regular fa-star text-warning"></i>
                                                                    </li>
                                                                @endfor
                                                            </ul>
                                                        </div>
                                                    </div>

                                                    <!-- Progress-bar START -->
                                                    <div class="col-md-8">
                                                        <div class="card-body p-0">
                                                            <div class="row gx-3 g-2 align-items-center">
                                                                <!-- Progress bar and Rating -->
                                                                <div class="col-9 col-sm-10">
                                                                    <!-- Progress item -->
                                                                    <div
                                                                        class="progress progress-sm bg-warning bg-opacity-15">
                                                                        <div class="progress-bar bg-warning"
                                                                            role="progressbar"
                                                                            style="width: {{ $fivestaraverage }}%"
                                                                            aria-valuenow="{{ $fivestaraverage }}"
                                                                            aria-valuemin="0" aria-valuemax="100">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <!-- Percentage -->
                                                                <div class="col-3 col-sm-2 text-end">
                                                                    <span
                                                                        class="h6 fw-semibold mb-0 text-dark">{{ number_format($fivestaraverage, 1) }}%</span>
                                                                </div>

                                                                <!-- Progress bar and Rating -->
                                                                <div class="col-9 col-sm-10">
                                                                    <!-- Progress item -->
                                                                    <div
                                                                        class="progress progress-sm bg-warning bg-opacity-15">
                                                                        <div class="progress-bar bg-warning"
                                                                            role="progressbar"
                                                                            style="width: {{ $fourstaraverage }}%"
                                                                            aria-valuenow="{{ $fourstaraverage }}"
                                                                            aria-valuemin="0" aria-valuemax="100">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <!-- Percentage -->
                                                                <div class="col-3 col-sm-2 text-end">
                                                                    <span
                                                                        class="h6 fw-semibold mb-0 text-dark">{{ number_format($fourstaraverage, 1) }}%</span>
                                                                </div>

                                                                <!-- Progress bar and Rating -->
                                                                <div class="col-9 col-sm-10">
                                                                    <!-- Progress item -->
                                                                    <div
                                                                        class="progress progress-sm bg-warning bg-opacity-15">
                                                                        <div class="progress-bar bg-warning"
                                                                            role="progressbar"
                                                                            style="width: {{ $threestaraverage }}%"
                                                                            aria-valuenow="{{ $threestaraverage }}"
                                                                            aria-valuemin="0" aria-valuemax="100">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <!-- Percentage -->
                                                                <div class="col-3 col-sm-2 text-end">
                                                                    <span
                                                                        class="h6 fw-semibold mb-0 text-dark">{{ number_format($threestaraverage, 1) }}%</span>
                                                                </div>

                                                                <!-- Progress bar and Rating -->
                                                                <div class="col-9 col-sm-10">
                                                                    <!-- Progress item -->
                                                                    <div
                                                                        class="progress progress-sm bg-warning bg-opacity-15">
                                                                        <div class="progress-bar bg-warning"
                                                                            role="progressbar"
                                                                            style="width: {{ $twostaraverage }}%"
                                                                            aria-valuenow="{{ $twostaraverage }}"
                                                                            aria-valuemin="0" aria-valuemax="100">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <!-- Percentage -->
                                                                <div class="col-3 col-sm-2 text-end">
                                                                    <span
                                                                        class="h6 fw-semibold mb-0 text-dark">{{ number_format($twostaraverage, 1) }}%</span>
                                                                </div>

                                                                <!-- Progress bar and Rating -->
                                                                <div class="col-9 col-sm-10">
                                                                    <!-- Progress item -->
                                                                    <div
                                                                        class="progress progress-sm bg-warning bg-opacity-15">
                                                                        <div class="progress-bar bg-warning"
                                                                            role="progressbar"
                                                                            style="width: {{ $onestaraverage }}%"
                                                                            aria-valuenow="{{ $onestaraverage }}"
                                                                            aria-valuemin="0" aria-valuemax="100">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <!-- Percentage -->
                                                                <div class="col-3 col-sm-2 text-end">
                                                                    <span
                                                                        class="h6 fw-semibold mb-0 text-dark">{{ number_format($onestaraverage, 1) }}%</span>
                                                                </div>
                                                            </div> <!-- Row END -->
                                                        </div>
                                                    </div>
                                                    <!-- Progress-bar END -->
                                                </div>
                                            </div>
                                            <!-- Customer Review -->
                                            <!-- comment section -->
                                            <form class="mb-5"
                                                action="{{ URL::to($vendordata->slug . '/postreview') }}" method="POST">
                                                @csrf
                                                <!-- rating option -->
                                                <div class="rating mb-3">
                                                    <input type="hidden" name="product_id" id="product_id"
                                                        value="{{ $productdata->id }}">
                                                    <select class="form-select border-0 bg-light py-2 px-3" name="ratting"
                                                        aria-label="Default select example">
                                                        <option selected="" value="5">★★★★★ (5/5)</option>
                                                        <option value="4">★★★★☆ (4/5)</option>
                                                        <option value="3">★★★☆☆ (3/5)</option>
                                                        <option value="2">★★☆☆☆ (2/5)</option>
                                                        <option value="1">★☆☆☆☆ (1/5)</option>
                                                    </select>
                                                </div>
                                                <!-- rating option -->
                                                <div class="form-control bg-light mb-3 border-0">
                                                    <textarea class="form-control border-0 bg-light p-0" id="exampleFormControlTextarea1" placeholder="Your review"
                                                        rows="4" name="review" required></textarea>
                                                </div>
                                                <button type="submit"
                                                    class="btn btn-fashion float-end">{{ trans('labels.post_review') }}</button>
                                            </form>
                                            <!-- comment section -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                    @endif

                </div>
                <!-- description section end-->
            </div>
        </section>
        <!-- PRODUCTS VIEW AREA END -->
    @else
        @include('web.nodata')
    @endif
    <!-- RELATED PRODUCTS AREA START -->
    @if (count($getrelatedproductslist) > 0)
        <section class="best-product pro-hover">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-heading py-4">
                            <h4 class="text-dark text-truncate">{{ trans('labels.top_related_products') }}</h4>
                            <a href="{{ URL::to(@$vendordata->slug . '/category?category=' . $productdata['category_info']->slug) }}"
                                class="btn btn-fashion ">{{ trans('labels.viewall') }}</a>
                        </div>
                    </div>
                </div>
                <div class="row row-cols-2 row-cols-md-3 row-cols-lg-4 row-cols-xl-5">
                    @foreach ($getrelatedproductslist as $getproductdata)
                        @include('web.productcommonview')
                    @endforeach
                </div>
            </div>
        </section>
    @endif
    <!-- RELATED PRODUCTS AREA END -->
@endsection
@section('scripts')
    <script>
        var formate = "{{ helper::appdata($vendordata->id)->currency_formate }}";
    </script>
    <script src="{{ url(env('ASSETPATHURL') . 'web-assets/js/smoothproducts.js') }}"></script>
    <script src="{{ url(env('ASSETPATHURL') . 'web-assets/js/products.js') }}"></script>
@endsection
