<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\helper\helper;
use App\Models\Order;
use App\Models\User;
use App\Models\OrderDetails;
use Illuminate\Support\Facades\Auth;
use PDF;
use Config;
class OrderController extends Controller
{
    public function index(Request $request)
    {
        if (Auth::user()->type == 4) {
            $vendor_id = Auth::user()->vendor_id;
        } else {
            $vendor_id = Auth::user()->id;
        }
        $getorders = Order::where('vendor_id', $vendor_id);
        if ($request->has('status') && $request->status != "") {
            if ($request->status == "processing") {
                $getorders = $getorders->whereIn('status', array(1, 2));
            }
            if ($request->status == "completed") {
                $getorders = $getorders->whereIn('status', array(5));
            }
            if ($request->status == "cancelled") {
                $getorders = $getorders->whereIn('status', array(4));
            }
            if ($request->status == "rejected") {
                $getorders = $getorders->where('status', array(3));
            }
        }
        $totalorders = Order::where('vendor_id', $vendor_id)->count();
        $totalprocessing = Order::whereIn('status', [1, 2])->where('vendor_id', $vendor_id)->count();
        $totalrevenue = Order::where('vendor_id', $vendor_id)->where('status', 5)->sum('grand_total');
        $totalcompleted = Order::where('status', 5)->where('vendor_id', $vendor_id)->count();
        $totalcancelled = Order::where('status', 4)->where('vendor_id', $vendor_id)->count();
        $totalrejected = Order::where('status', 3)->where('vendor_id', $vendor_id)->count();
        if (!empty($request->startdate) && !empty($request->enddate)) {
            $getorders = $getorders->whereBetween('created_at', [$request->startdate, $request->enddate]);
            $totalprocessing = Order::whereIn('status', array(2))->where('vendor_id', $vendor_id)->whereBetween('created_at', [$request->startdate, $request->enddate])->count();
            $totalrevenue = Order::where('status', 5)->where('vendor_id', $vendor_id)->whereBetween('created_at', [$request->startdate, $request->enddate])->sum('grand_total');
            $totalcompleted = Order::where('status', 5)->where('vendor_id', $vendor_id)->whereBetween('created_at', [$request->startdate, $request->enddate])->count();
            $totalcancelled = Order::whereIn('status', array(3, 4))->where('vendor_id', $vendor_id)->whereBetween('created_at', [$request->startdate, $request->enddate])->count();
        }
        $getorders = $getorders->orderByDesc('id')->get();
        return view('admin.orders.index', compact('getorders', 'totalorders', 'totalprocessing', 'totalcompleted', 'totalcancelled', 'totalrevenue', 'totalrejected'));
    }
    public function update(Request $request)
    {
        $orderdata = Order::find($request->id);
        if (empty($orderdata) || !in_array($request->status, [2, 3, 5])) {
            abort(404);
        }
        $title = "";
        $message_text = "";
        if ($request->status == "2") {
            $title = trans('labels.order_accepted');
            $message_text = 'Your Order ' . $orderdata->order_number . ' has been accepted by Admin';
        }
        if ($request->status == "5") {
            $title = trans('labels.order_delivered');
            $message_text = 'Your Order ' . $orderdata->order_number . ' has been successfully delivered.';
        }
        if ($request->status == "3") {
            $title = trans('labels.order_calcelled');
            $message_text = 'Order ' . $orderdata->order_number . ' has been cancelled by Admin.';
        }
        $vendor = User::select('id', 'name')->where('id', $orderdata->vendor_id)->first();
        $emaildata = helper::emailconfigration($vendor->id);
        Config::set('mail', $emaildata);
        $status_email = helper::order_status_email($orderdata->user_email, $orderdata->user_name, $title, $message_text, $vendor);
        $orderdata->status = $request->status;
        $orderdata->save();
        return redirect()->back()->with('success', trans('messages.success'));
    }
    public function invoice(Request $request)
    {
        $getorderdata = Order::where('order_number', $request->order_number)->first();
        if (empty($getorderdata)) {
            abort(404);
        }
        $ordersdetails = OrderDetails::where('order_id', $getorderdata->id)->get();
        return view('admin.orders.invoice', compact('getorderdata', 'ordersdetails'));
    }
    public function print(Request $request)
    {
        $getorderdata = Order::where('order_number', $request->order_number)->first();
        if (empty($getorderdata)) {
            abort(404);
        }
        $ordersdetails = OrderDetails::where('order_id', $getorderdata->id)->get();
        return view('admin.orders.print', compact('getorderdata', 'ordersdetails'));
    }

    public function generatepdf(Request $request)
    {
        $getorderdata = Order::where('order_number', $request->order_number)->first();
        $ordersdetails = OrderDetails::where('order_id', $getorderdata->id)->get();
        $pdf = PDF::loadView('admin.orders.invoicepdf', ['getorderdata' => $getorderdata, 'ordersdetails' => $ordersdetails]);
        return $pdf->download('orderinvoice.pdf');
    }
}
