<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\Theme;
use Illuminate\Http\Request;

use function PHPUnit\Framework\returnSelf;

class ThemeController extends Controller
{
    public function index(Request $request)
    {
        $themes = Theme::where('vendor_id',1)->get();
        return view('admin.theme.index',compact('themes'));
    }
    public function add(Request $request)
    {
        return view('admin.theme.add');
    }
    public function edit(Request $request)
    {
        $theme = Theme::where('vendor_id',1)->where('id',$request->id)->first();
        return view('admin.theme.edit',compact('theme'));
    }
    public function update(Request $request)
    {
        $edittheme = theme::where('id',$request->id)->first();
        $edittheme->name = $request->name;
        $edittheme->vendor_id = Auth::user()->id;
        if ($request->hasfile('image')) {
            $request->validate([
                'image' => 'image',
            ], [
                'image.image' => trans('messages.enter_image_file'),
            ]);
            if (file_exists(storage_path('app/public/admin-assets/images/theme/' . $edittheme->theme))) {
                @unlink(storage_path('app/public/admin-assets/images/theme/' . $edittheme->theme));
            }
            $theme = 'theme-' . uniqid() . '.' . $request->image->getClientOriginalExtension();
            $request->file('image')->move(storage_path('app/public/admin-assets/images/theme/'), $theme);
            $edittheme->image = $theme;
        }
        $edittheme->save();
        return redirect('admin/themes')->with('success',trans('messages.success'));
    }
    public function save(Request $request)
    {
        $newtheme = new theme();
        $newtheme->name = $request->name;
        $newtheme->vendor_id = Auth::user()->id;
         if ($request->hasfile('image')) {
            $request->validate([
                'image' => 'image',
            ], [
                'image.image' => trans('messages.enter_image_file'),
            ]);
            $theme = 'theme-' . uniqid() . '.' . $request->image->getClientOriginalExtension();
            $request->file('image')->move(storage_path('app/public/admin-assets/images/theme/'), $theme);
            $newtheme->image = $theme;
        }
        $newtheme->save();
        return redirect('admin/themes')->with('success',trans('messages.success'));
    }
    public function delete(Request $request)
    {
        $theme = Theme::where('id',$request->id)->first();
        if (file_exists(storage_path('app/public/admin-assets/images/theme/' . $theme->image))) {
            unlink(storage_path('app/public/admin-assets/images/theme/' . $theme->image));
        }
        $theme->delete();
        return redirect('admin/themes')->with('success',trans('messages.success'));
    }
}