<?php
namespace App\Http\Controllers\admin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Settings;
use App\Models\AppSettings;
use App\Models\Transaction;
use App\Models\TopDeals;
use App\Models\LandingSettings;
use App\Models\Footerfeatures;
use App\Models\FunFact;
use Illuminate\Support\Facades\Auth;
class WebSettingsController extends Controller
{
    public function basic_settings()
    {
        if (Auth::user()->type == 4) {
            $vendor_id = Auth::user()->vendor_id;
        } else {
            $vendor_id = Auth::user()->id;
        }
        $settingdata =  Settings::where('vendor_id', $vendor_id)->first();
        $theme = Transaction::select('themes_id')->where('vendor_id', $vendor_id)->orderByDesc('id')->first();
        $getfooterfeatures = Footerfeatures::where('vendor_id', $vendor_id)->get();
        $app = AppSettings::where('vendor_id', $vendor_id)->first();
        $funfacts = FunFact::where('vendor_id', $vendor_id)->get();
        $landingdata = LandingSettings::where('vendor_id', $vendor_id)->first();
        $topdeals = TopDeals::where('vendor_id', $vendor_id)->first();
        return view('admin.landing.index', compact('settingdata','theme','app','funfacts','landingdata','getfooterfeatures','topdeals'));
    }
    public function themeupdate(Request $request)
    {
        if (Auth::user()->type == 4) {
            $vendor_id = Auth::user()->vendor_id;
        } else {
            $vendor_id = Auth::user()->id;
        }
        $settingsdata = Settings::where('vendor_id', $vendor_id)->first();
        if ($request->hasfile('logo')) {
            $request->validate([
                'logo' => 'image',
            ], [
                "logo.image" => trans('messages.enter_image_file'),
            ]);
            if ($settingsdata->logo != "defaultlogo.png" && $settingsdata->logo != "" && file_exists(storage_path('app/public/admin-assets/images/about/logo/' . $settingsdata->logo))) {
                unlink(storage_path('app/public/admin-assets/images/about/logo/' . $settingsdata->logo));
            }
            $logo_name = 'logo-' . uniqid() . '.' . $request->logo->getClientOriginalExtension();
            $request->file('logo')->move(storage_path('app/public/admin-assets/images/about/logo/'), $logo_name);
            $settingsdata->logo = $logo_name;
        }
        if ($request->hasfile('favicon')) {
            $request->validate([
                'favicon' => 'image',
            ], [
                "favicon.image" => trans('messages.enter_image_file'),
            ]);
            if ($settingsdata->favicon != "defaultlogo.png" && $settingsdata->favicon != "" && file_exists(storage_path('app/public/admin-assets/images/about/favicon/' . $settingsdata->favicon))) {
                unlink(storage_path('app/public/admin-assets/images/about/favicon/' . $settingsdata->favicon));
            }
            $favicon_name = 'favicon-' . uniqid() . '.' . $request->favicon->getClientOriginalExtension();
            $request->favicon->move(storage_path('app/public/admin-assets/images/about/favicon/'), $favicon_name);
            $settingsdata->favicon = $favicon_name;
        }
       
        if (Auth::user()->type == 1) {
            $settingsdata->landing_website_title = $request->landing_website_title;
        }
        if(Auth::user()->type == 2)
        { 
            $settingsdata->web_title = $request->web_title;
            $settingsdata->copyright = $request->copyright;
        }
        $settingsdata->primary_color = $request->primary_color;
        $settingsdata->secondary_color = $request->secondary_color;
        $settingsdata->landing_page = isset($request->landing_page) ? 1 : 2;
        $settingsdata->theme = !empty($request->template) ? $request->template : 1;
        $settingsdata->save();
        return redirect()->back()->with('success', trans('messages.success'));
    }
    public function seo_update(Request $request)
    {
        try {
            if (Auth::user()->type == 4) {
                $vendor_id = Auth::user()->vendor_id;
            } else {
                $vendor_id = Auth::user()->id;
            }
            $settingsdata = Settings::where('vendor_id', $vendor_id)->first();
            $settingsdata->meta_title = $request->meta_title;
            $settingsdata->meta_description = $request->meta_description;
            if ($request->hasfile('og_image')) {
                if ($settingsdata->og_image != "" && file_exists(storage_path('app/public/admin-assets/images/about/og_image/' . $settingsdata->og_image))) {
                    unlink(storage_path('app/public/admin-assets/images/about/og_image/' . $settingsdata->og_image));
                }
                $image = 'og_image-' . uniqid() . '.' . $request->og_image->getClientOriginalExtension();
                $request->og_image->move(storage_path('app/public/admin-assets/images/about/og_image/'), $image);
                $settingsdata->og_image = $image;
            }
            $settingsdata->save();
            return redirect()->back()->with('success', trans('messages.success'));
        } catch (\Throwable $th) {
            return redirect()->back()->with('success', trans('messages.success'));
        }
    }
    public function footer_features_update(Request $request)
    {
        if (Auth::user()->type == 4) {
            $vendor_id = Auth::user()->vendor_id;
        } else {
            $vendor_id = Auth::user()->id;
        }
        if (!empty($request->feature_icon)) {
            foreach ($request->feature_icon as $key => $icon) {
                if (!empty($icon) && !empty($request->feature_title[$key]) && !empty($request->feature_description[$key])) {
                    $feature = new Footerfeatures;
                    $feature->vendor_id = $vendor_id;
                    $feature->icon = $icon;
                    $feature->title = $request->feature_title[$key];
                    $feature->description = $request->feature_description[$key];
                    $feature->save();
                }
            }
        }
        if (!empty($request->edit_icon_key)) {
            foreach ($request->edit_icon_key as $key => $id) {
                $feature = Footerfeatures::find($id);
                $feature->icon = $request->edi_feature_icon[$id];
                $feature->title = $request->edi_feature_title[$id];
                $feature->description = $request->edi_feature_description[$id];
                $feature->save();
            }
        }
        return redirect()->back()->with('success', trans('messages.success'));
    }
    public function delete_feature(Request $request)
    {
        Footerfeatures::where('id', $request->id)->delete();
        return redirect()->back()->with('success', trans('messages.success'));
    }
    public function app_section(Request $request)
    {
        if (Auth::user()->type == 4) {
            $vendor_id = Auth::user()->vendor_id;
        } else {
            $vendor_id = Auth::user()->id;
        }
        $appsection = AppSettings::where('vendor_id', $vendor_id)->first();
        if (empty($appsection)) {
            $appsection = new AppSettings();
        }
        $appsection->vendor_id = $vendor_id;
        $appsection->title = $request->title;
        $appsection->subtitle = $request->sub_title;
        $appsection->android_link = $request->android_link;
        $appsection->ios_link = $request->ios_link;
        if ($request->has('image')) {
            if (!empty($appsection->image)) {
                if (file_exists(storage_path('app/public/admin-assets/images/index/' .  $appsection->image))) {
                    unlink(storage_path('app/public/admin-assets/images/index/' .  $appsection->image));
                }
            }
            $image = 'appsection-' . uniqid() . "." . $request->file('image')->getClientOriginalExtension();
            $request->file('image')->move(storage_path('app/public/admin-assets/images/index/'), $image);
            $appsection->image = $image;
        }
        $appsection->save();
        return redirect()->back()->with('success', trans('messages.success'));
    }
    public function fun_fact_update(Request $request)
    {
        if (Auth::user()->type == 4) {
            $vendor_id = Auth::user()->vendor_id;
        } else {
            $vendor_id = Auth::user()->id;
        }
        if (!empty($request->funfact_icon)) {
            foreach ($request->funfact_icon as $key => $icon) {
                if (!empty($icon) && !empty($request->funfact_title[$key]) && !empty($request->funfact_subtitle[$key])) {
                    $funfact = new FunFact;
                    $funfact->vendor_id = $vendor_id;
                    $funfact->icon = $icon;
                    $funfact->title = $request->funfact_title[$key];
                    $funfact->description = $request->funfact_subtitle[$key];
                    $funfact->save();
                }
            }
        }
        if (!empty($request->edit_icon_key)) {
            foreach ($request->edit_icon_key as $key => $id) {
                $funfact = FunFact::find($id);
                $funfact->icon = $request->edi_funfact_icon[$id];
                $funfact->title = $request->edi_funfact_title[$id];
                $funfact->description = $request->edi_funfact_subtitle[$id];
                $funfact->save();
            }
        }
        return redirect()->back()->with('success', trans('messages.success'));
    }
    public function fun_fact_delete(Request $request)
    {
        FunFact::where('id', $request->id)->delete();
        return redirect()->back()->with('success', trans('messages.success'));
    }
    public function contact_settings(Request $request)
    {
        if (Auth::user()->type == 4) {
            $vendor_id = Auth::user()->vendor_id;
        } else {
            $vendor_id = Auth::user()->id;
        }
        $settingdata = Settings::where('vendor_id', $vendor_id)->first();
        if (empty($settingdata)) {
            $settingdata = new Settings();
        }
        $settingdata->email = $request->landing_email;
        $settingdata->contact = $request->landing_mobile;
        $settingdata->address = $request->landing_address;
        $settingdata->facebook_link = $request->landing_facebook_link;
        $settingdata->twitter_link = $request->landing_twitter_link;
        $settingdata->instagram_link = $request->landing_instagram_link;
        $settingdata->linkedin_link = $request->landing_linkedin_link;
        $settingdata->save();
        return redirect()->back()->with('success', trans('messages.success'));
    }
    public function other_update(Request $request)
    {
        if (Auth::user()->type == 4) {
            $vendor_id = Auth::user()->vendor_id;
        } else {
            $vendor_id = Auth::user()->id;
        }
        if (Auth::user()->type == 1) {
            $landingsettings = LandingSettings::where('vendor_id', $vendor_id)->first();
          
            if (empty($landingsettings)) {
               
                $landingsettings = new LandingSettings();
            }
            if ($request->hasfile('landing_home_banner')) {
                $request->validate([
                    'landing_home_banner' => 'image',
                ], [
                    "landing_home_banner.image" => trans('messages.enter_image_file'),
                ]);
                if (file_exists(storage_path('app/public/admin-assets/images/banner/' . $landingsettings->landing_home_banner))) {
                    @unlink(storage_path('app/public/admin-assets/images/banner/' . $landingsettings->landing_home_banner));
                }
                $bannerimage = 'banner-' . uniqid() . '.' . $request->landing_home_banner->getClientOriginalExtension();
                $request->landing_home_banner->move(storage_path('app/public/admin-assets/images/banner/'), $bannerimage);
                $landingsettings->landing_home_banner = $bannerimage;
            }
            if ($request->hasfile('testimonial_image')) {
                $request->validate([
                    'testimonial_image' => 'image',
                ], [
                    "testimonial_image.image" => trans('messages.enter_image_file'),
                ]);
                if (file_exists(storage_path('app/public/admin-assets/images/testimonials/' . $landingsettings->testimonial_image))) {
                    @unlink(storage_path('app/public/admin-assets/images/testimonials/' . $landingsettings->testimonial_image));
                }
                $bannerimage = 'testimonial-' . uniqid() . '.' . $request->testimonial_image->getClientOriginalExtension();
                $request->testimonial_image->move(storage_path('app/public/admin-assets/images/testimonials/'), $bannerimage);
                $landingsettings->testimonial_image = $bannerimage;
            }
            if ($request->hasfile('subscribe_image')) {
                $request->validate([
                    'subscribe_image' => 'image',
                ], [
                    "subscribe_image.image" => trans('messages.enter_image_file'),
                ]);
                if (file_exists(storage_path('app/public/admin-assets/images/about/subscribe/' . $landingsettings->subscribe_image))) {
                    @unlink(storage_path('app/public/admin-assets/images/about/subscribe/' . $landingsettings->subscribe_image));
                }
                $bannerimage = 'subscribe-' . uniqid() . '.' . $request->subscribe_image->getClientOriginalExtension();
                $request->subscribe_image->move(storage_path('app/public/admin-assets/images/about/subscribe/'), $bannerimage);
                $landingsettings->subscribe_image = $bannerimage;
            }
            $landingsettings->vendor_id = $vendor_id;
            $landingsettings->save();
        }
        if (Auth::user()->type == 2) {
            $settingdata = Settings::where('vendor_id', $vendor_id)->first();
            if ($request->hasfile('subscribe_image')) {
                $request->validate([
                    'subscribe_image' => 'image',
                ], [
                    "subscribe_image.image" => trans('messages.enter_image_file'),
                ]);
                if (file_exists(storage_path('app/public/admin-assets/images/about/subscribe/' . $settingdata->subscribe_image))) {
                    @unlink(storage_path('app/public/admin-assets/images/about/subscribe/' . $settingdata->subscribe_image));
                }
                $bannerimage = 'subscribe-' . uniqid() . '.' . $request->subscribe_image->getClientOriginalExtension();
                $request->subscribe_image->move(storage_path('app/public/admin-assets/images/about/subscribe/'), $bannerimage);
                $settingdata->subscribe_image = $bannerimage;
            }
            if ($request->hasfile('viewallpage_banner')) {
                $request->validate([
                    'viewallpage_banner' => 'image',
                ], [
                    "viewallpage_banner.image" => trans('messages.enter_image_file'),
                ]);
                if (!empty($settingdata->viewallpage_banner) && file_exists(storage_path('app/public/admin-assets/images/about/viewallpage_banner/' . $settingdata->viewallpage_banner))) {
                    unlink(storage_path('app/public/admin-assets/images/about/viewallpage_banner/' . $settingdata->viewallpage_banner));
                }
                $viewallpage_banner = 'viewallpage_banner-' . uniqid() . '.' . $request->file('viewallpage_banner')->getClientOriginalExtension();
                $request->file('viewallpage_banner')->move(storage_path('app/public/admin-assets/images/about/viewallpage_banner/'), $viewallpage_banner);
                $settingdata->viewallpage_banner = $viewallpage_banner;
            }
            if ($request->hasfile('landin_page_cover_image')) {
                $request->validate([
                    'landin_page_cover_image' => 'image',
                ], [
                    "landin_page_cover_image.image" => trans('messages.enter_image_file'),
                ]);
                if ($settingdata->cover_image != "cover.png" && file_exists(storage_path('app/public/admin-assets/images/coverimage/' . $settingdata->cover_image))) {
                    @unlink(storage_path('app/public/admin-assets/images/coverimage/' . $settingdata->cover_image));
                }
                $coverimage = 'cover-' . uniqid() . '.' . $request->landin_page_cover_image->getClientOriginalExtension();
                $request->landin_page_cover_image->move(storage_path('app/public/admin-assets/images/coverimage/'), $coverimage);
                $settingdata->cover_image = $coverimage;
            }
            if ($request->hasfile('contact_image')) {
                $request->validate([
                    'contact_image' => 'image',
                ], [
                    "contact_image.image" => trans('messages.enter_image_file'),
                ]);
                if (file_exists(storage_path('app/public/admin-assets/images/contact/' . $settingdata->contact_image))) {
                    @unlink(storage_path('app/public/admin-assets/images/contact/' . $settingdata->contact_image));
                }
                $contact_image = 'contact-' . uniqid() . '.' . $request->contact_image->getClientOriginalExtension();
                $request->contact_image->move(storage_path('app/public/admin-assets/images/contact/'), $contact_image);
                $settingdata->contact_image = $contact_image;
            }
            if ($request->hasfile('order_detail_image')) {
                $request->validate([
                    'order_detail_image' => 'image',
                ], [
                    "order_detail_image.image" => trans('messages.enter_image_file'),
                ]);
                if (file_exists(storage_path('app/public/admin-assets/images/index/' . $settingdata->order_detail_image))) {
                    @unlink(storage_path('app/public/admin-assets/images/index/' . $settingdata->order_detail_image));
                }
                $order_detail_image = 'order-' . uniqid() . '.' . $request->order_detail_image->getClientOriginalExtension();
                $request->order_detail_image->move(storage_path('app/public/admin-assets/images/index/'), $order_detail_image);
                $settingdata->order_detail_image = $order_detail_image;
                
            }
            if ($request->hasfile('auth_image')) {
                $request->validate([
                    'auth_image' => 'image',
                ], [
                    "auth_image.image" => trans('messages.enter_image_file'),
                ]);
                if (file_exists(storage_path('app/public/admin-assets/images/index/' . $settingdata->auth_image))) {
                    @unlink(storage_path('app/public/admin-assets/images/index/' . $settingdata->auth_image));
                }
                $auth_image = 'auth-' . uniqid() . '.' . $request->auth_image->getClientOriginalExtension();
                $request->auth_image->move(storage_path('app/public/admin-assets/images/index/'), $auth_image);
                $settingdata->auth_image = $auth_image;
                
            }

            if ($request->hasfile('order_success_image')) {
                $request->validate([
                    'order_success_image' => 'image',
                ], [
                    "order_success_image.image" => trans('messages.enter_image_file'),
                ]);
                if (file_exists(storage_path('app/public/admin-assets/images/index/' . $settingdata->order_success_image))) {
                    @unlink(storage_path('app/public/admin-assets/images/index/' . $settingdata->order_success_image));
                }
                $order_success_image = 'auth-' . uniqid() . '.' . $request->order_success_image->getClientOriginalExtension();
                $request->order_success_image->move(storage_path('app/public/admin-assets/images/index/'), $order_success_image);
                $settingdata->order_success_image = $order_success_image;
                
            }
            $settingdata->footer_description = $request->footer_description;
            $settingdata->save();
        }
        return redirect()->back()->with('success', trans('messages.success'));
    }
    public function top_deals(Request $request)
    {
        if (Auth::user()->type == 4) {
            $vendor_id = Auth::user()->vendor_id;
        } else {
            $vendor_id = Auth::user()->id;
        }
        $settingdata = TopDeals::where('vendor_id', $vendor_id)->first();
        if(empty($settingdata))
        {
            $settingdata = new TopDeals();
        }
        $settingdata->vendor_id = $vendor_id;
        $settingdata->start_date = $request->top_deals_start_date;
        $settingdata->end_date = $request->top_deals_end_date;
        $settingdata->start_time = $request->top_deals_start_time;
        $settingdata->end_time = $request->top_deals_end_time;
        $settingdata->offer_type = $request->offer_type;
        $settingdata->offer_amount = $request->amount;
        $settingdata->save();
        return redirect()->back()->with('success', trans('messages.success'));
    }
}
