<?php

namespace App\Http\Controllers\web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\helper\helper;
use App\Models\Cart;
use App\Models\Payment;
use App\Models\Shippingarea;
use App\Models\Order;
use App\Models\OrderDetails;
use App\Models\Settings;
use Illuminate\Support\Facades\Auth;
use Stripe;
use Validator;
use Config;

class CheckoutController extends Controller
{
    public function index(Request $request)
    {

        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);

            $vdata = $vendordata->id;
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
            
            $vdata = $vendordata->vendor_id;
        }

        if (empty($vendordata)) {
            abort(404);
        }
        $getcartlist = Cart::where('session_id', session()->getId())->where('vendor_id', @$vdata)->get();
        if (Auth::user() && Auth::user()->type == 3) {

            $getcartlist = Cart::where('vendor_id', @$vdata)->where('user_id', Auth::user()->id)->get();
        }
        if (@session()->get('discount_data')['vendor_id'] != @$vdata) {
            session()->forget('discount_data');
        }
        $getpaymentmethodslist = Payment::where('is_available', 1)->where('vendor_id', @$vdata)->whereNotIn('payment_name', ['wallet'])->where('is_activate', 1)->get();
        $getshippingarealist = Shippingarea::where('vendor_id', @$vdata)->where('is_available', 1)->orderByDesc('id')->get();
        return view('web.checkout.index', compact('vendordata', 'getcartlist', 'getpaymentmethodslist', 'getshippingarealist'));
    }
    public function ordersuccess(Request $request)
    {
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);

            $vdata = $vendordata->id;
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
            
            $vdata = $vendordata->vendor_id;
        }

        if (empty($vendordata)) {
            abort(404);
        }
        $order_number = $request->order_number;
        $checkorderdata = Order::where('vendor_id', @$vdata)->where('order_number', $order_number)->first();
        $whmessage = helper::whatsappmessage($order_number, $request->vendor_slug, $vendordata);
        if (empty($checkorderdata)) {
            abort(404);
        }
        return view('web.orders.success', compact('vendordata', 'order_number', 'whmessage','vdata'));
    }
    public function orderdetails(Request $request)
    {
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);

            $vdata = $vendordata->id;
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
            
            $vdata = $vendordata->vendor_id;
        }

        if (empty($vendordata)) {
            abort(404);
        }
        $order_number = $request->order;
        $getorderdata = Order::where('vendor_id', @$vdata)->where('order_number', $request->order)->first();

        $getorderitemlist = OrderDetails::where('order_id', @$getorderdata->id)->get();
        return view('web.orders.order_details', compact('vendordata', 'getorderdata', 'getorderitemlist', 'order_number'));
    }
    public function cancelorder(Request $request)
    {
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);

            $vdata = $vendordata->id;
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
            
            $vdata = $vendordata->vendor_id;
        }

        if (empty($vendordata)) {
            abort(404);
        }
        $getorderdata = Order::where('vendor_id', @$vdata)->where('order_number', $request->order_number)->first();
        if (empty($getorderdata)) {
            abort(404);
        }
        if ($getorderdata->status == 2) {
            return redirect()->back()->with('error', trans('messages.already_accepted'));
        } else if (in_array($getorderdata->status, [3, 4])) {
            return redirect()->back()->with('error', trans('messages.already_rejected'));
        } else if ($getorderdata->status == 5) {
            return redirect()->back()->with('error', trans('messages.already_delivered'));
        }
        $getorderdata->status = 4;
        $getorderdata->save();
        $title = trans('labels.order_calcelled');
        $message_text = 'Order ' . $getorderdata->order_number . ' has been cancelled by' . $getorderdata->user_name;
        $emaildata = helper::emailconfigration($vdata);
        Config::set('mail', $emaildata);
        helper::cancel_order($vendordata->email, $vendordata->name, $title, $message_text, $getorderdata);
        return redirect($request->vendor_slug . '/find-order?order=' . $request->order_number)->with('success', trans('messages.success'));
    }
    public function orderlimit(Request $request)
    {
        // PASS SECOND PARAM 3 WHEN CHECKING HELPER FROM WEB END PASS IS BLANK --> ''

        $checkplan = helper::checkplan($request->vendor_id, 3);
        $v = json_decode(json_encode($checkplan));
        if (@$v->original->status == 2) {
            return response()->json(['status' => 0, 'message' => @$v->original->message], 200);
        }
    }
    public function placeorder(Request $request)
    {
       
        $transaction_id = $request->transaction_id;
        $filename = "";
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);
            $vdata = $vendordata->id;
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
            $vdata = $vendordata->vendor_id;
        }
        if (Auth::user() && Auth::user()->type == 3) {
            $user_id = Auth::user()->id;
            $user_name = Auth::user()->name;
            $user_email = Auth::user()->email;
            $user_mobile = Auth::user()->mobile;
        } else {
            $user_id = 0;
            $user_name = $request->user_name;
            $user_email = $request->user_email;
            $user_mobile = $request->user_mobile;
        }
        if ($request->transaction_type == '3') {
            try {
                $stripekey = helper::stripe_data($vdata)->secret_key;
                Stripe\Stripe::setApiKey($stripekey);
                $charge = Stripe\Charge::create([
                    'amount' => $request->grand_total * 100,
                    'currency' => helper::stripe_data($vdata)->currency,
                    "description" => "Ecom-SAAS-OrderPayment",
                    'source' => $request->transaction_id,
                ]);

                if ($request->transaction_id == "") {
                    $transaction_id = $charge->id;
                } else {
                    $transaction_id = $request->transaction_id;
                }
            } catch (Exception $th) {
                return response()->json(['status' => 0, 'message' => trans('messages.unable_to_complete_payment')], 200);
            }
        }
        if ($request->modal_transaction_type == '6') {
            if ($request->hasFile('screenshot')) {
                $validator = Validator::make($request->all(), [
                    'screenshot' => 'image|mimes:jpg,jpeg,png',
                ], [
                    'screenshot.mage' => trans('messages.enter_image_file'),
                    'screenshot.mimes' => trans('messages.valid_image'),
                ]);
                if ($validator->fails()) {
                    return redirect()->back()->withErrors($validator)->withInput();
                } else {
                    $filename = 'screenshot-' . uniqid() . "." . $request->file('screenshot')->getClientOriginalExtension();
                    $request->file('screenshot')->move(env('ASSETPATHURL') . 'admin-assets/images/screenshot/', $filename);
                }
            }
            $transaction_id = "";
            $data = helper::createorder($request->modal_vendor_slug, "", $user_id, $request->modal_user_name, $request->modal_user_email, $request->modal_user_mobile, 6, $transaction_id, $request->modal_billing_address, $request->modal_billing_landmark, $request->modal_billing_postal_code, $request->modal_billing_city, $request->modal_billing_state, $request->modal_billing_country, $request->modal_shipping_address, $request->modal_shipping_landmark, $request->modal_shipping_postal_code, $request->modal_shipping_city, $request->modal_shipping_state, $request->modal_shipping_country, $request->modal_shipping_area, $request->modal_delivery_charge, $request->modal_grand_total, $request->modal_sub_total, $request->modal_tax, $request->modal_notes, $request->modal_offer_code, $request->modal_offer_amount, $filename);
            $data = json_decode(json_encode($data), true);
            if ($data['original']['status'] == 1) {
                session()->forget('discount_data');
            }
            return redirect($request->modal_vendor_slug . '/orders-success-' . $data['original']['order_number'])->with('success', trans('messages.success'));
        } else {
            $data = helper::createorder($request->vendor_slug, "", $user_id, $user_name, $user_email, $user_mobile, $request->transaction_type, $transaction_id, $request->billing_address, $request->billing_landmark, $request->billing_postal_code, $request->billing_city, $request->billing_state, $request->billing_country, $request->shipping_address, $request->shipping_landmark, $request->shipping_postal_code, $request->shipping_city, $request->shipping_state, $request->shipping_country, $request->shipping_area, $request->delivery_charge, $request->grand_total, $request->sub_total, $request->tax_amount, $request->notes, $request->offer_code, $request->offer_amount, $filename);
            $data = json_decode(json_encode($data), true);
            if ($data['original']['status'] == 1) {
                session()->forget('discount_data');
            }
            return response()->json(['status' => 1, 'order_number' => $data['original']['order_number'],$data['original']], 200);
        }
    }
    public function paymentrequestsuccess(Request $request)
    {
        try {

            if (session()->has('mdata')) {
                if (Auth::user() && Auth::user()->type == 3) {
                    $user_id = Auth::user()->id;
                    $user_name = Auth::user()->name;
                    $user_email = Auth::user()->email;
                    $user_mobile = Auth::user()->mobile;
                } else {
                    $user_id = 0;
                    $user_name = session()->get('mdata')['user_name'];
                    $user_email = session()->get('mdata')['user_email'];
                    $user_mobile = session()->get('mdata')['user_mobile'];
                }
                if (@$request->paymentId != "") {
                    $paymentid = $request->paymentId;
                }
                if (@$request->payment_id != "") {
                    $paymentid = $request->payment_id;
                }
                if (@$request->transaction_id != "") {
                    $paymentid = $request->transaction_id;
                }
                $data = helper::createorder(session()->get('mdata')['vendor_slug'], "", $user_id, $user_name, $user_email, $user_mobile, session()->get('mdata')['transaction_type'], $paymentid, session()->get('mdata')['billing_address'], session()->get('mdata')['billing_landmark'], session()->get('mdata')['billing_postal_code'], session()->get('mdata')['billing_city'], session()->get('mdata')['billing_state'], session()->get('mdata')['billing_country'], session()->get('mdata')['shipping_address'], session()->get('mdata')['shipping_landmark'], session()->get('mdata')['shipping_postal_code'], session()->get('mdata')['shipping_city'], session()->get('mdata')['shipping_state'], session()->get('mdata')['shipping_country'], session()->get('mdata')['shipping_area'], session()->get('mdata')['delivery_charge'], session()->get('mdata')['grand_total'], session()->get('mdata')['sub_total'], session()->get('mdata')['tax_amount'], session()->get('mdata')['notes'], session()->get('mdata')['offer_code'], session()->get('mdata')['offer_amount'], '');
                $data = json_decode(json_encode($data), true);
                session()->forget('mdata');
                return redirect()->to(@$data['original']['successurl']);
            }
        } catch (\Throwable $th) {

            return $th;
        }
    }
}
