<?php

namespace App\Http\Controllers\web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\helper\helper;
use App\Models\User;
use App\Models\Cart;
use App\Models\Order;
use App\Models\Products;
use App\Models\Settings;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\SystemAddons;
use Lunaweb\RecaptchaV3\Facades\RecaptchaV3;
use Config;
use Illuminate\Support\Str;
use URL;
use DB;

class UserController extends Controller
{
    public function user_login(Request $request)
    {

        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
        }

        if (empty($vendordata)) {
            abort(404);
        }
        if (
            SystemAddons::where('unique_identifier', 'customer_login')->first() != null &&
            SystemAddons::where('unique_identifier', 'customer_login')->first()->activated == 1
        ) {
            if (helper::appdata($vendordata->id)->checkout_login_required == 1) {
                return view('web.auth.login', compact('vendordata'));
            }
            else {
                abort(404);
            }
        }
    }

    public function user_register(Request $request)
    {
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
        }

        if (empty($vendordata)) {
            abort(404);
        }
        if (
            SystemAddons::where('unique_identifier', 'customer_login')->first() != null &&
            SystemAddons::where('unique_identifier', 'customer_login')->first()->activated == 1
        ) {
            if (helper::appdata($vendordata->id)->checkout_login_required == 1) {
                return view('web.auth.register', compact('vendordata'));
            }
            else {
                abort(404);
            }
        } 
    }
    public function userforgotpassword(Request $request)
    {
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
        }
        if (empty($vendordata)) {
            abort(404);
        }
        if (SystemAddons::where('unique_identifier', 'customer_login')->first() != null &&
            SystemAddons::where('unique_identifier', 'customer_login')->first()->activated == 1) {
            if (helper::appdata($vendordata->id)->checkout_login_required == 1) {
                return view('web.auth.forgotpassword', compact('vendordata'));
            }
            else {
                abort(404);
            }
        }
    }
    public function register_customer(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users,email',
            'password' => 'required',
            'mobile' => 'required|unique:users,mobile',
        ], [
            'name.required' => trans('messages.name_required'),
            'email.required' => trans('messages.email_required'),
            'email.email' =>  trans('messages.invalid_email'),
            'email.unique' => trans('messages.unique_email'),
            'password.required' => trans('messages.password_required'),
            'mobile.required' => trans('messages.mobile_required'),
            'mobile.unique' => trans('messages.unique_mobile'),
        ]);
        if (
            SystemAddons::where('unique_identifier', 'cookie_recaptcha')->first() != null &&
            SystemAddons::where('unique_identifier', 'cookie_recaptcha')->first()->activated == 1
        ) {

            if (helper::appdata('')->recaptcha_version == 'v2') {
                $request->validate([
                    'g-recaptcha-response' => 'required'
                ], [
                    'g-recaptcha-response.required' => 'The g-recaptcha-response field is required.'
                ]);
            }

            if (helper::appdata('')->recaptcha_version == 'v3') {
                $score = RecaptchaV3::verify($request->get('g-recaptcha-response'), 'contact');
                if ($score <= helper::appdata('')->score_threshold) {
                    return redirect()->back()->with('error', 'You are most likely a bot');
                }
            }
        }

        $newuser = new User();
        $newuser->name = $request->name;
        $newuser->email = $request->email;
        $newuser->password = hash::make($request->password);
        $newuser->mobile = $request->mobile;
        $newuser->type = "3";
        $newuser->login_type = "normal";
        $newuser->image = "default.png";
        $newuser->is_available = "1";
        $newuser->is_verified = "1";
        $newuser->wallet = 0;
        $newuser->save();
        return redirect($request->vendor_slug . '/login')->with('success', trans('messages.success'));
    }


    public function check_login(Request $request)
    {
        try {
            $host = $_SERVER['HTTP_HOST'];
            if ($host  ==  env('WEBSITE_HOST')) {
                $vendordata = helper::vendordata($request->vendor_slug);
            }
            // if the current host doesn't contain the website domain (meaning, custom domain)
            else {
                $vendordata = Settings::where('custom_domain', $host)->first();
            }
            if ($request->logintype == "normal") {
                $request->validate([
                    'email' => 'required|email',
                    'password' => 'required',
                ], [
                    'email.required' => trans('messages.email_required'),
                    'email.email' =>  trans('messages.invalid_email'),
                    'password.required' => trans('messages.password_required'),
                ]);
                $old_sid = session()->getId();
                session()->put('user_login', 1);
                if (Auth::attempt($request->only('email', 'password'))) {
                    if (Auth::user()->type == 3) {
                        if (Auth::user()->is_available == 1) {
                            if (Str::contains(session()->get('previous_url'), 'products')) {
                                $previous_url = session()->get('previous_url');
                            } else {
                                $previous_url = URL::to($vendordata->slug);
                            }
                            session()->put('old_sid', $old_sid);
                            if (Auth::user() && Auth::user()->type == 3) {
                                Cart::where('session_id', $old_sid)->update(['user_id' => Auth::user()->id, 'session_id' => NULL]);
                            }
                            return redirect($previous_url)->with('sucess', trans('messages.success'));
                        } else {
                            Auth::logout();
                            return redirect()->back()->with('error', trans('messages.block'));
                        }
                    } else {

                        Auth::logout();
                        return redirect()->back()->with('error', trans('messages.email_password_not_match'));
                    }
                } else {

                    return redirect()->back()->with('error', trans('messages.email_password_not_match'));
                }
            }
        } catch (Exception $exception) {
            return back()->withError($exception->getMessage())->withInput();
        }
    }
    public function send_userpassword(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
        ], [
            'email.required' => trans('messages.email_required'),
            'email.email' =>  trans('messages.invalid_email'),
        ]);
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);

            $vdata = $vendordata->id;
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();

            $vdata = $vendordata->vendor_id;
        }
        if (empty($vendordata)) {
            abort(404);
        }
        $checkuser = User::where('email', $request->email)->where('is_available', 1)->where('type', 3)->first();
        if (!empty($checkuser)) {
            $password = substr(str_shuffle($checkuser->password), 1, 6);
            $emaildata = helper::emailconfigration($vdata);
            Config::set('mail', $emaildata);
            $check_send_mail = helper::send_mail_forpassword($request->email, $checkuser->name, $password, helper::appdata('')->logo);
            if ($check_send_mail == 1) {
                $checkuser->password = Hash::make($password);
                $checkuser->save();
                return redirect('/' . $request->vendor_slug . '/login')->with('success', trans('messages.success'));
            } else {
                return redirect('/' . $request->vendor_slug . '/forgot_password')->with('error', trans('messages.wrong'));
            }
        } else {
            return redirect()->back()->with('error', trans('messages.invalid_user'));
        }
    }
    public function logout(Request $request)
    {

        session()->flush();
        Auth::logout();
        return redirect('/' . $request->vendor_slug);
    }

    public function my_profile(Request $request)
    {
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
        }

        if (empty($vendordata)) {
            abort(404);
        }
        $getprofile = User::where('id', Auth::user()->id)->first();
        return view('web.user.profile', compact('vendordata', 'getprofile'));
    }

    public function edit_profile(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users,email,' . Auth::user()->id,
            'mobile' => 'required|unique:users,mobile,' . Auth::user()->id,
        ], [
            'name.required' => trans('messages.name_required'),
            'email.required' => trans('messages.email_required'),
            'email.email' =>  trans('messages.invalid_email'),
            'email.unique' => trans('messages.unique_email'),
            'mobile.required' => trans('messages.mobile_required'),
            'mobile.unique' => trans('messages.unique_mobile'),
        ]);
        $user = User::where('id', $request->id)->first();
        $user->name = $request->name;
        $user->mobile = $request->mobile;
        if ($request->has('image')) {
            if ($user->image != "" && file_exists(storage_path('app/public/admin-assets/images/profile/' . $user->image))) {
                unlink(storage_path('app/public/admin-assets/images/profile/' . $user->image));
            }
            $profileImage = 'profile-' . uniqid() . "." . $request->file('image')->getClientOriginalExtension();
            $request->file('image')->move(storage_path('app/public/admin-assets/images/profile/'), $profileImage);
            $user->image = $profileImage;
        }
        $user->save();
        return redirect()->back()->with('success', trans('messages.success'));
    }

    public function changepassword(Request $request)
    {
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
        }

        if (empty($vendordata)) {
            abort(404);
        }
        return view('web.user.changepassword', compact('vendordata'));
    }

    public function updatepassword(Request $request)
    {
        $request->validate([
            'current_password' => 'required',
            'new_password' => 'required',
            'confirm_password' => 'required',
        ], [
            'current_password.required' => trans('messages.current_password_required'),
            'new_password.required' => trans('messages.new_password_required'),
            'confirm_password.unique' => trans('messages.confirm_password_required'),
        ]);
        $user = User::where('id', Auth::user()->id)->first();
        if (Hash::check($request->current_password, Auth::user()->password)) {
            if ($request->current_password == $request->new_password) {
                return redirect()->back()->with('error', trans('messages.new_old_password_diffrent'));
            } else {
                if ($request->new_password == $request->confirm_password) {
                    $changepassword = User::where('id', Auth::user()->id)->first();
                    $changepassword->password = Hash::make($request->new_password);
                    $changepassword->update();
                    return redirect()->back()->with('success',  trans('messages.success'));
                } else {
                    return redirect()->back()->with('error', trans('messages.new_confirm_password_inccorect'));
                }
            }
        } else {
            return redirect()->back()->with('error', trans('messages.old_password_incorect'));
        }
        return view('front.user.changepassword', compact('vendordata'));
    }

    public function orders(Request $request)
    {
        $orders = Order::where('user_id', Auth::user()->id);
        if (!empty($request->type)) {
            if ($request->type == "rejected") {
                $orders = $orders->whereIn('status', [3, 4]);
            }
            if ($request->type == "processing") {
                $orders = $orders->whereIn('status', [1, 2]);
            }
            if ($request->type == "completed") {
                $orders = $orders->where('status', 5);
            }
        }
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
        }

        if (empty($vendordata)) {
            abort(404);
        }
        $orders = $orders->orderByDesc('id')->get();
        $totalprocessing = Order::where('user_id', Auth::user()->id)->whereIn('status', [1, 2])->count();
        $totalrejected = Order::where('user_id', Auth::user()->id)->whereIn('status', [3, 4])->count();
        $totalcompleted = Order::where('user_id', Auth::user()->id)->where('status', 5)->count();
        return view('web.user.orders', compact('vendordata', 'orders', 'totalprocessing', 'totalrejected', 'totalcompleted'));
    }
    public function wishlist_product(Request $request)
    {
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);

            $vdata = $vendordata->id;
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();

            $vdata = $vendordata->vendor_id;
        }

        if (empty($vendordata)) {
            abort(404);
        }
        $getfavourite = Products::with('product_image', 'multi_variation', 'category_info')->select('products.id', 'products.category_id', 'products.sub_category_id', 'products.name', 'products.slug', 'products.has_variation', 'products.attribute', 'products.price', 'products.original_price', 'products.tax', 'products.description', 'products.is_available', 'products.is_deleted', 'products.created_at', 'products.updated_at', DB::raw('ROUND(AVG(testimonials.star),1) as ratings_average'))->leftjoin('favorite', 'favorite.product_id', '=', 'products.id')->leftJoin('testimonials', 'testimonials.product_id', '=', 'products.id')->groupBy('products.id')->where('favorite.vendor_id', $vdata)->where('products.vendor_id', $vdata)
            ->where('favorite.user_id', Auth::user()->id)->where('products.top_deals','!=','1')
            ->where('products.is_available', 1)->where('products.is_deleted', 2)->paginate(9);
        return view('web.user.favourite', compact('vendordata', 'getfavourite'));
    }
    public function deleteaccount(Request $request)
    {
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);

            $vdata = $vendordata->id;
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();

            $vdata = $vendordata->vendor_id;
        }

        if (empty($vendordata)) {
            abort(404);
        }
        if (Auth::user() && Auth::user()->type == 3) {
            $user  = User::where('id', Auth::user()->id)->first();
            $user->is_available = 2;
            $user->update();
            $emaildata = helper::emailconfigration($vdata);
            Config::set('mail', $emaildata);
            helper::send_mail_delete_account($user);
            session()->flush();
            Auth::logout();
        }
        return redirect('/' . $request->vendor_slug);
    }

    public function deleteprofile(Request $request)
    {
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);
            $vdata = $vendordata->id;
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
            $vdata = $vendordata->vendor_id;
        }
        if (empty($vendordata)) {
            abort(404);
        }
        return view('web.user.delete_account',compact('vendordata'));
    }
}
