<?php

namespace App\helper;

use App\Models\Order;
use App\Models\OrderDetails;
use App\Models\Settings;
use App\Models\User;
use App\Models\Footerfeatures;
use App\Models\Transaction;
use App\Models\Category;
use App\Models\SubCategory;
use App\Models\Blog;
use App\Models\PricingPlan;
use App\Models\Products;
use App\Models\SystemAddons;
use App\Models\Cart;
use App\Models\Favorite;
use App\Models\Languages;
use App\Models\TopDeals;
use App\Models\RoleAccess;
use App\Models\Variation;
use App\Models\RoleManager;
use App\Models\Payment;
use App\Models\Customdomain;
use App\Models\Pixcel;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;
use URL;
use App;
use Illuminate\Support\Facades\Auth;
use Config;
class helper
{
    // admin
    public static function appdata($vendor_id)
    {
        if (file_exists(storage_path('installed'))) {
            $host = @$_SERVER['HTTP_HOST'];
            if ($host  ==  env('WEBSITE_HOST')) {
                $data = Settings::first();
                if (!empty($vendor_id)) {
                    $data = Settings::where('vendor_id', $vendor_id)->first();
                }
            }
            // if the current host doesn't contain the website domain (meaning, custom domain)
            else {
                $data = Settings::where('custom_domain', $host)->first();
            }
                    
            return $data;
        } else {
            return redirect('install');
            exit;
        }
    }
    public static function decimal_formate($price)
    {
        $price = floatval($price);
        return number_format($price, 2);
    }
    public static function currency_formate($price, $vendor_id)
    {
       
        $price = floatval($price);
        if (@helper::appdata($vendor_id)->currency_position == "1") {
                return @helper::appdata($vendor_id)->currency . number_format($price,helper::appdata($vendor_id)->currency_formate);
        }
        if (@helper::appdata($vendor_id)->currency_position == "2") {
                return number_format($price,helper::appdata($vendor_id)->currency_formate) . @helper::appdata($vendor_id)->currency;
        }
        return $price;
    }
    public static function date_formate($date)
    {
        return date('d M Y', strtotime($date));
    }
    // all mail=================================================================
    public static function send_mail_forpassword($email,$name, $password, $logo)
    {
        $data = ['title' => trans('labels.email_verification'), 'email' => $email, 'name' => $name, 'password' => $password, 'logo' => helper::image_path($logo)];
        try {
            Mail::send('email.sendpassword', $data, function ($message) use ($data) {
                $message->to($data['email'])->subject($data['title']);
            });
            return 1;
        } catch (\Throwable $th) {
            return 0;
        }
    }
    public static function send_mail_delete_account($vendor)
    {
        $data = ['title' => trans('labels.account_deleted'),'vendor_name' => $vendor->name,'email' => $vendor->email];
        try {
            Mail::send('email.accountdeleted', $data, function ($message) use ($data) {
                $message->to($data['email'])->subject($data['title']);
            });
            return 1;
        } catch (\Throwable $th) {
            return 0;
        }
    }
    public static function send_mail_forotp($name, $email, $otp, $logo)
    {
        $data = ['title' => trans('labels.email_verification'), 'email' => $email, 'name' => $name, 'otp' => $otp, 'logo' => helper::image_path($logo)];
        try {
            Mail::send('email.otpverification', $data, function ($message) use ($data) {
                $message->to($data['email'])->subject($data['title']);
            });
            return 1;
        } catch (\Throwable $th) {
            return 0;
        }
    }
    public static function bank_transfer_request($vendor_email, $vendor_name, $plan_name, $duration, $price, $payment_method, $transaction_id)
    {
        $admininfo = User::where('id', '1')->first();
        $data = ['title' =>  trans('labels.banktransfer'), 'vendor_email' => $vendor_email, 'vendor_name' => $vendor_name, 'admin_email' => $admininfo->email, 'admin_name' => $admininfo->name, 'plan_name' => $plan_name, 'duration' => $duration, 'price' => $price, 'payment_method' => $payment_method, 'transaction_id' => $transaction_id];
        $adminemail = ['title' =>  trans('labels.banktransfer'), 'vendor_email' => $vendor_email, 'vendor_name' => $vendor_name, 'admin_email' => $admininfo->email, 'admin_name' => $admininfo->name, 'plan_name' => $plan_name, 'duration' => $duration, 'price' => $price, 'payment_method' => $payment_method, 'transaction_id' => $transaction_id];
        try {
            Mail::send('email.banktransfervendor', $data, function ($message) use ($data) {
                $message->to($data['vendor_email'])->subject($data['title']);
            });

            Mail::send('email.banktransferadmin', $adminemail, function ($message) use ($adminemail) {
                $message->to($adminemail['admin_email'])->subject($adminemail['title']);
            });
            return 1;
        } catch (\Throwable $th) {
            return 0;
        }
    }
    public static function cod_request($vendor_email, $vendor_name, $plan_name, $duration, $price, $payment_method, $transaction_id)
    {
        $admininfo = User::where('id', '1')->first();
        $data = ['title' =>  trans('labels.cod'), 'vendor_email' => $vendor_email, 'vendor_name' => $vendor_name, 'admin_email' => $admininfo->email, 'admin_name' => $admininfo->name, 'plan_name' => $plan_name, 'duration' => $duration, 'price' => $price, 'payment_method' => $payment_method, 'transaction_id' => $transaction_id];
        $adminemail = ['title' =>  trans('labels.cod'), 'vendor_email' => $vendor_email, 'vendor_name' => $vendor_name, 'admin_email' => $admininfo->email, 'admin_name' => $admininfo->name, 'plan_name' => $plan_name, 'duration' => $duration, 'price' => $price, 'payment_method' => $payment_method, 'transaction_id' => $transaction_id];
        try {
            Mail::send('email.codvendor', $data, function ($message) use ($data) {
                $message->to($data['vendor_email'])->subject($data['title']);
            });

            Mail::send('email.banktransferadmin', $adminemail, function ($message) use ($adminemail) {
                $message->to($adminemail['admin_email'])->subject($adminemail['title']);
            });
            return 1;
        } catch (\Throwable $th) {
            return 0;
        }
    }

    public static function subscription_rejected($vendor_email, $vendor_name, $plan_name, $payment_method)
    {
        $title = trans('labels.plan_request_rejected');
        if($payment_method == 6)
        {
            $payment_method = "Bank Transfer";
        }
        if($payment_method == 1)
        {
            $payment_method = "COD";
        }
        $admindata = User::select('name', 'email')->where('id', '1')->first();
        $data = ['title' => "$title", 'vendor_email' => $vendor_email, 'vendor_name' => $vendor_name, 'admin_email' => $admindata->email, 'admin_name' => $admindata->name, 'plan_name' => $plan_name, 'payment_method' => $payment_method];
        try {
            Mail::send('email.banktransferreject', $data, function ($message) use ($data) {
                $message->to($data['vendor_email'])->subject($data['title']);
            });
            return 1;
        } catch (\Throwable $th) {
            return 0;
        }
    }
    public static function send_subscription_email($vendor_email, $vendor_name, $plan_name, $duration, $price, $payment_method, $transaction_id)
    {
        $title = trans('labels.new_subscription_plan');
        $admininfo = User::where('id', '1')->first();
        $data = ['title' => $title, 'vendor_email' => $vendor_email, 'vendor_name' => $vendor_name, 'admin_email' => $admininfo->email, 'admin_name' => $admininfo->name, 'plan_name' => $plan_name, 'duration' => $duration, 'price' => $price, 'payment_method' => $payment_method, 'transaction_id' => $transaction_id];

        $adminemail = ['title' => $title, 'vendor_email' => $vendor_email, 'vendor_name' => $vendor_name, 'admin_email' => $admininfo->email, 'admin_name' => $admininfo->name, 'plan_name' => $plan_name, 'duration' => $duration, 'price' => $price, 'payment_method' => $payment_method, 'transaction_id' => $transaction_id];

        try {
            Mail::send('email.subscription', $data, function ($message) use ($data) {
                $message->to($data['vendor_email'])->subject($data['title']);
            });

            Mail::send('email.adminsubscription', $adminemail, function ($message) use ($adminemail) {
                $message->to($adminemail['admin_email'])->subject($adminemail['title']);
            });
            return 1;
        } catch (\Throwable $th) {
            return 1;
        }
    }
    public static function create_order_invoice($customer_email,$customer_name,$vendoremail,$vendorname,$vendorid,$order_number,$date,$trackurl,$grandtotal)
    {
        $data = ['title' => trans('labels.new_order_invoice'),'customer_email' => $customer_email, 'customer_name' => $customer_name, 'company_email' => $vendoremail, 'vendorname' => $vendorname, 'order_number' => $order_number, 'delivery_date' => $date,'grand_total' => $grandtotal, 'trackurl' => $trackurl,'vendorid' => $vendorid];
     
        try {
            Mail::send('email.emailinvoice', $data, function ($message) use ($data) {
                $message->to($data['customer_email'])->subject($data['title']);
            });

            Mail::send('email.orderemail', $data, function ($message) use ($data) {
                $message->to($data['company_email'])->subject($data['title']);
            });
            return 1;
        } catch (\Throwable $th) {
            return 0;
        }
    }
    public static function vendor_contact_data($vendor_name, $vendor_email, $full_name, $useremail, $usermobile, $usermessage)
    {
        $data = ['title' => trans('labels.inquiry'), 'vendor_name' => $vendor_name, 'vendor_email' => $vendor_email, 'full_name' => $full_name, 'useremail' => $useremail, 'usermobile' => $usermobile, 'usermessage' => $usermessage];
        try {
            Mail::send('email.vendorcontact', $data, function ($message) use ($data) {
                $message->to($data['vendor_email'])->subject($data['title']);
            });
            return 1;
        } catch (\Throwable $th) {
            return 0;
        }
    }
    public static function send_mail_vendor_register($vendor)
    {
      
        $user = User::where('id',1)->first();
        $data = ['title'=> trans('labels.registration'),'title1'=>'New Vendor Registration','vendor_name' => $vendor->name, 'vendor_email' => $vendor->email,'admin_email' => $user->email,"vendor_mobile" => $vendor->mobile,'admin_name'=>$user->name];
        try {
            Mail::send('email.vendorregister', $data, function ($message) use ($data) {
                $message->to($data['vendor_email'])->subject($data['title']);
            });

            Mail::send('email.newvendorregistration', $data, function ($message) use ($data) {
                $message->to($data['admin_email'])->subject($data['title1']);
            });
            return 1;
        } catch (\Throwable $th) {
            return 0;
        }
    }
    public static function send_mail_vendor_block($vendor)
    {
        $data = ['title'=> trans('labels.account_deleted'),'vendor_name' => $vendor->name, 'vendor_email' => $vendor->email];
        try {
            Mail::send('email.vendorbloked', $data, function ($message) use ($data) {
                $message->to($data['vendor_email'])->subject($data['title']);
            });
            return 1;
        } catch (\Throwable $th) {
            return 0;
        }
    }
    public static function order_status_email($email, $name, $title, $message_text, $vendor)
    {
        $data = ['email' => $email, 'name' => $name, 'title' => $title,'vendor'=>$vendor->name, 'message_text' => $message_text, 'logo' => Helper::image_path(@Helper::appdata($vendor->id)->logo)];
        try {
            Mail::send('email.orderstatus', $data, function ($message) use ($data) {
                $message->to($data['email'])->subject($data['title']);
            });
            return 1;
        } catch (\Throwable $th) {
            return 0;
        }
    }
    public static function cancel_order($email, $name, $title, $message_text, $vendor)
    {
        $data = ['email' => $email, 'name' => $name, 'title' => $title,'vendor'=>$vendor->user_name, 'message_text' => $message_text, 'logo' => Helper::image_path(@Helper::appdata($vendor->id)->logo)];
        try {
            Mail::send('email.orderstatus', $data, function ($message) use ($data) {
                $message->to($data['email'])->subject($data['title']);
            });
            return 1;
        } catch (\Throwable $th) {
            return 0;
        }
    }
    // all Mail End===========================================================================================
    public static function image_path($image)
    {
        $url = url(env('ASSETPATHURL') . 'admin-assets/images/about/no_data.png');
        if (Str::contains($image, 'profile')) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/profile/' . $image);
        }
        if (Str::contains($image, 'category')) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/categories/' . $image);
        }
        if (Str::contains($image, 'product')) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/product/' . $image);
        }
        if (Str::contains($image, 'login') || Str::contains($image, 'default')) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/about/' . $image);
        }
        if (Str::contains($image, 'payment')  || Str::contains($image, 'cod') || Str::contains($image, 'stripe') || Str::contains($image, 'paystack') || Str::contains($image, 'razorpay') || Str::contains($image, 'wallet') || Str::contains($image, 'flutterwave') || Str::contains($image, 'bank') || Str::contains($image, 'mercadopago') || Str::contains($image, 'paypal') || Str::contains($image, 'myfatoorah') || Str::contains($image, 'toyyibpay')) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/about/payment/' . $image);
        }
        if (Str::contains($image, 'logo')) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/about/logo/' . $image);
        }
        if (Str::contains($image, 'favicon')) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/about/favicon/' . $image);
        }
        if (Str::contains($image, 'og_image')) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/about/og_image/' . $image);
        }
        if (Str::contains($image, 'banner') || Str::contains($image, 'promotion')) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/banner/' . $image);
        }
        if (Str::contains($image, 'blog')) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/blog/' . $image);
        }
        if (Str::contains($image, 'flag')) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/language/' . $image);
        }
        if (Str::contains($image, 'subscribe')) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/about/subscribe/' . $image);
        }
        if (Str::contains($image, 'screenshot')) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/screenshot/' . $image);
        }
        if (Str::contains($image, 'viewallpage_banner')) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/about/viewallpage_banner/' . $image);
        }
        if (Str::contains($image, 'order_success')) {
            $url = url(env('ASSETPATHURL') . 'web-assets/images/' . $image);
        }
        if (Str::contains($image, 'feature-')) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/feature/' . $image);
        }
        if (Str::contains($image, 'testimonial-')) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/testimonials/' . $image);
        }
        if (Str::contains($image, 'theme-')) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/theme/' . $image);
        }
        if (Str::contains($image, 'cover')) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/coverimage/' . $image);
        }
        if (Str::contains($image, 'app') || Str::contains($image, 'work') || Str::contains($image, 'whoweare') || Str::contains($image, 'order') || Str::contains($image, 'auth') ) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/index/' . $image);
        }
        if (Str::contains($image, 'gallery') ) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/gallery/' . $image);
        }
        if (Str::contains($image, 'contact') ) {
            $url = url(env('ASSETPATHURL') . 'admin-assets/images/contact/' . $image);
        }
        return $url;
    }
    
    public static function checkplan($id, $type)
    {
        $check = SystemAddons::where('unique_identifier', 'subscription')->first();

        if (@$check->activated != 1) {
            return response()->json(['status' => 1, 'message' => '', 'expdate' => "", 'showclick' => "0", 'plan_message' => '', 'plan_date' => '', 'checklimit' => '', 'bank_transfer' => ''], 200);
        }
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            date_default_timezone_set(helper::appdata($id)->timezone);
            $vendorinfo = User::where('id', $id)->first();
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $storeinfo = Settings::where('custom_domain', $host)->first();
            date_default_timezone_set(helper::appdata($storeinfo->vendor_id)->timezone);
            $vendorinfo = User::where('id', $storeinfo->vendor_id)->first();
        }
        $checkplan = Transaction::where('plan_id', $vendorinfo->plan_id)->where('vendor_id', $vendorinfo->id)->orderByDesc('id')->first();
       
        $totalservice = Products::where('vendor_id', $vendorinfo->id)->count();
        if ($vendorinfo->allow_without_subscription != 1) {
            if (!empty($checkplan)) {
                if ($vendorinfo->is_available == 2) {
                    return response()->json(['status' => 2, 'message' => trans('messages.account_blocked_by_admin'), 'showclick' => "0", 'plan_message' => '', 'plan_date' => '', 'checklimit' => '','bank_transfer' => ''], 200);
                }
                if ($checkplan->payment_type == 1) {
                    if ($checkplan->status == 1) {
                        return response()->json(['status' => 2, 'message' => trans('messages.cod_pending'), 'showclick' => "0", 'plan_message' => trans('messages.cod_pending'), 'plan_date' => '', 'checklimit' => '','bank_transfer' => '1'], 200);
                    } elseif ($checkplan->status == 3) {
                        return response()->json(['status' => 2, 'message' => trans('messages.cod_rejected'), 'showclick' => "1", 'plan_message' => trans('messages.cod_rejected'), 'plan_date' => '', 'checklimit' => '','bank_transfer' => ''], 200);
                    }
                }
                if ($checkplan->payment_type == 6) {
                    if ($checkplan->status == 1) {
                        return response()->json(['status' => 2, 'message' => trans('messages.bank_request_pending'), 'showclick' => "0", 'plan_message' => trans('messages.bank_request_pending'), 'plan_date' => '', 'checklimit' => '','bank_transfer' => '1'], 200);
                    } elseif ($checkplan->status == 3) {
                        return response()->json(['status' => 2, 'message' => trans('messages.bank_request_rejected'), 'showclick' => "1", 'plan_message' => trans('messages.bank_request_rejected'), 'plan_date' => '', 'checklimit' => '','bank_transfer' => ''], 200);
                    }
                }
                if ($checkplan->expire_date != "") {
                    if (date('Y-m-d') > $checkplan->expire_date) {
                        return response()->json(['status' => 2, 'message' => trans('messages.plan_expired'), 'expdate' => $checkplan->expire_date, 'showclick' => "1", 'plan_message' => trans('messages.plan_expired'), 'plan_date' => $checkplan->expire_date, 'checklimit' => '','bank_transfer' => ''], 200);
                    }
                }
                if (Str::contains(request()->url(), 'admin')) {
                    if ($checkplan->service_limit != -1) {
                        if ($totalservice >= $checkplan->service_limit) {
                            if (Auth::user()->type == 1) {
                                return response()->json(['status' => 2, 'message' => trans('messages.products_limit_exceeded'), 'expdate' => '', 'showclick' => "1", 'plan_message' => trans('messages.plan_expires'), 'plan_date' => '', 'checklimit' => '','bank_transfer' => ''], 200);
                            }
                            if (Auth::user()->type == 2) {
                                if ($checkplan->expire_date != "") {
                                    return response()->json(['status' => 2, 'message' => trans('messages.vendor_products_limit_message'), 'expdate' => '', 'showclick' => "2", 'plan_message' => trans('messages.plan_expires'), 'plan_date' => $checkplan->expire_date, 'checklimit' => 'service','bank_transfer' => ''], 200);
                                } else {
                                    return response()->json(['status' => 2, 'message' => trans('messages.vendor_products_limit_message'), 'expdate' => '', 'showclick' => "2", 'plan_message' => trans('messages.lifetime_subscription'), 'plan_date' => $checkplan->expire_date, 'checklimit' => 'service','bank_transfer' => ''], 200);
                                }
                            }
                        }
                    }
                    if ($checkplan->appoinment_limit != -1) {
                        if ($checkplan->appoinment_limit <= 0) {
                            if (Auth::user()->type == 1) {
                                return response()->json(['status' => 2, 'message' => trans('messages.order_limit_exceeded'), 'expdate' => '', 'showclick' => "1", 'plan_message' => trans('messages.plan_expires'), 'plan_date' => '', 'checklimit' => '','bank_transfer' => ''], 200);
                            }
                            if (Auth::user()->type == 2) {
                                if ($checkplan->expire_date != "") {
                                    return response()->json(['status' => 2, 'message' => trans('messages.vendor_order_limit_message'), 'expdate' => '', 'showclick' => "1", 'plan_message' => trans('messages.plan_expires'), 'plan_date' => $checkplan->expire_date, 'checklimit' => 'booking','bank_transfer' => ''], 200);
                                } else {
                                    return response()->json(['status' => 2, 'message' => trans('messages.vendor_order_limit_message'), 'expdate' => '', 'showclick' => "1", 'plan_message' => trans('messages.lifetime_subscription'), 'plan_date' => $checkplan->expire_date, 'checklimit' => 'service','bank_transfer' => ''], 200);
                                }
                            }
                        }
                    }
                }
                if ($type == 3) {
                    if ($checkplan->appoinment_limit != -1) {
                        if ($checkplan->appoinment_limit <= 0) {
                            return response()->json(['status' => 2, 'message' => trans('messages.front_store_unavailable'), 'expdate' => '', 'showclick' => "1", 'plan_message' => trans('messages.plan_expires'), 'plan_date' => '', 'checklimit' => 'booking','bank_transfer' => ''], 200);
                        }
                    }
                }
                if ($checkplan->expire_date != "") {
                    return response()->json(['status' => 1, 'message' => trans('messages.plan_expires'), 'expdate' => $checkplan->expire_date, 'showclick' => "0", 'plan_message' => trans('messages.plan_expires'), 'plan_date' => $checkplan->expire_date, 'checklimit' => '','bank_transfer' => ''], 200);
                } else {
                    return response()->json(['status' => 1, 'message' => trans('messages.lifetime_subscription'), 'expdate' => $checkplan->expire_date, 'showclick' => "0", 'plan_message' => trans('messages.lifetime_subscription'), 'plan_date' => $checkplan->expire_date, 'checklimit' => '','bank_transfer' => ''], 200);
                }
            } else {
                if (Auth::user()->type == 1) {
                    return response()->json(['status' => 2, 'message' => trans('messages.doesnot_select_any_plan'), 'expdate' => '', 'showclick' => "0", 'plan_message' => '', 'plan_date' => '', 'checklimit' => '','bank_transfer' => ''], 200);
                }
                if (Auth::user()->type == 2) {
                    return response()->json(['status' => 2, 'message' => trans('messages.vendor_plan_purchase_message'), 'expdate' => '', 'showclick' => "1", 'plan_message' => '', 'plan_date' => '', 'checklimit' => '','bank_transfer' => ''], 200);
                }
            }
        }
    }
    public static function plandetail($plan_id)
    {
        $planinfo = PricingPlan::where('id', $plan_id)->first();
        return $planinfo;
    }

    // front
    public static function vendordata($slug)
    {
        $data = User::where('slug', $slug)->where('is_available', 1)->first();
        if (empty($data)) {
            abort(404);
        }
        return $data;
    }
    public static function footer_features($vendor_id)
    {
        return FooterFeatures::select('id', 'icon', 'title', 'description')->where('vendor_id', $vendor_id)->get();
    }
    // ------------------------------------------------------------------------
    // ------------------------------- BY RAHUL -------------------------------
    // ------------------------------------------------------------------------
    public static function stripe_data($vendor_id)
    {
        $data = Payment::select('environment', 'payment_name', 'public_key', 'secret_key', 'currency')->where('payment_name', 'stripe')->where('is_available', 1)->first();
        if ($vendor_id != "") {
            $data = Payment::select('environment', 'payment_name', 'public_key', 'secret_key', 'currency')->where('payment_name', 'stripe')->where('is_available', 1)->where('vendor_id',$vendor_id)->first();
        }
        return $data;
    }
    public static function get_plan_exp_date($duration, $days)
    {
        date_default_timezone_set(helper::appdata('')->timezone);
        $purchasedate = date("Y-m-d h:i:sa");
        $exdate = "";
        if (!empty($duration) && $duration != "") {
            if ($duration == "1") {
                $exdate = date('Y-m-d', strtotime($purchasedate . ' + 30 days'));
            }
            if ($duration == "2") {
                $exdate = date('Y-m-d', strtotime($purchasedate . ' + 90 days'));
            }
            if ($duration == "3") {
                $exdate = date('Y-m-d', strtotime($purchasedate . ' + 180 days'));
            }
            if ($duration == "4") {
                $exdate = date('Y-m-d', strtotime($purchasedate . ' + 365 days'));
            }
            if ($duration == "5") {
                $exdate = "";
            }
        }
        if (!empty($days) && $days != "") {
            $exdate = date('Y-m-d', strtotime($purchasedate . ' + ' . $days .  'days'));
        }
        return $exdate;
    }
    // Web
    public static function getmaxprice($vendor_id)
    {
        $d = Products::select('price')->where('is_available', 1)->where('is_deleted', 2)->where('vendor_id', $vendor_id)->orderByDesc('price')->first();
        if (!empty($d)) {
            $d = $d->price;
        } else {
            $d = 0;
        }
        return $d;
    }
    public static function getcartcount($vendor_id, $session_id, $user_id)
    {
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vdata = $vendor_id;
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
            $vdata = $vendordata->vendor_id;
        }

        if ($user_id != "") {
            $cnt = Cart::where('vendor_id', $vdata)->where('user_id', $user_id)->count();
        } else {
            $cnt = Cart::where('vendor_id', $vdata)->where('session_id', $session_id)->count();
        }
        return $cnt;
    }
    public static function getcategories($vendor_id, $limit)
    {
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vdata = $vendor_id;
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
            $vdata = $vendordata->vendor_id;
        }
        // NOTE :-- pass $limit = "" (blank) if need all records
        return Category::select('id', 'name', 'slug', 'image')->where('is_available', 1)->where('is_deleted', 2)->where('vendor_id', $vdata)->take($limit)->orderBy('reorder_id')->get();
    }
    public static function getsubcategories($category_id, $limit)
    {
        // NOTE :-- pass $limit = "" (blank) if need all records
        return SubCategory::select('id', 'category_id', 'name', 'slug')->where('is_available', 1)->where('is_deleted', 2)->where('category_id', $category_id)->orderBy('reorder_id')->take($limit)->get();
    }
    public static function getblogs($vendor_id, $limit, $unique)
    {
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vdata = $vendor_id;
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
            
            $vdata = $vendordata->vendor_id;
        }

        // NOTE :-- pass $limit = "" (blank) if need all records
        $data = Blog::where('vendor_id', $vdata)->orderByDesc('id')->take($limit)->get();
        if ($unique != "") {
            $data = Blog::where('vendor_id', $vdata)->where('id', '!=', $unique)->orderByDesc('id')->take($limit)->get();
        }
        return $data;
    }
    public static function createorder($vendor_slug,$session_id,$user_id, $user_name, $user_email, $user_mobile, $transaction_type, $transaction_id, $billing_address, $billing_landmark, $billing_postal_code, $billing_city, $billing_state, $billing_country, $shipping_address, $shipping_landmark, $shipping_postal_code, $shipping_city, $shipping_state, $shipping_country, $shipping_area, $delivery_charge, $grand_total, $sub_total, $tax_amount, $notes, $offer_code, $offer_amount,$filename)
    {
        try {
           
            $host = $_SERVER['HTTP_HOST'];
            if ($host  ==  env('WEBSITE_HOST')) {
                $vendordata = helper::vendordata($vendor_slug);

                $vdata = $vendordata->id;
            }
            // if the current host doesn't contain the website domain (meaning, custom domain)
            else {
                $vendordata = Settings::where('custom_domain', $host)->first();
                
                $vdata = $vendordata->vendor_id;
            }
            $checkplan = Transaction::where('vendor_id', @$vdata)->orderByDesc('id')->first();
            if ($checkplan->appoinment_limit == -1 || $checkplan->appoinment_limit > 0) {
                date_default_timezone_set(helper::appdata(@$vdata)->timezone);
                $order_number = substr(str_shuffle(str_repeat("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ", 10)), 0, 10);
                $trackurl = URL::to(@$vendordata->slug . '/find-order?order=' . $order_number);
                $successurl = URL::to(@$vendordata->slug . '/orders-success-' . $order_number);
                $order = new Order();
                if($user_id == "" || $user_id == null)
                {
                    if($session_id == "" || $session_id == null)
                    {
                        $session_id = session()->getId();
                    }
                }
                else
                {
                    $order->user_id = $user_id;
                }
                if ($user_id > 0) {
                    $checkcart = Cart::where('vendor_id', @$vdata)->where('user_id', $user_id)->get();
                } else {
                    $checkcart = Cart::where('vendor_id', @$vdata)->where('session_id', $session_id)->get();
                }
               
                if($checkcart->count() > 0)
                {
                  
                    $order->order_number = $order_number;
                    $order->vendor_id = @$vdata;
                    $order->user_name = $user_name;
                    $order->user_email = $user_email;
                    $order->user_mobile = $user_mobile;
                    $order->session_id = $session_id;
                    $order->billing_address = $billing_address;
                    $order->billing_landmark = $billing_landmark;
                    $order->billing_postal_code = $billing_postal_code;
                    $order->billing_city = $billing_city;
                    $order->billing_state = $billing_state;
                    $order->billing_country = $billing_country;
                    $order->shipping_address = $shipping_address;
                    $order->shipping_landmark = $shipping_landmark;
                    $order->shipping_postal_code = $shipping_postal_code;
                    $order->shipping_city = $shipping_city;
                    $order->shipping_state = $shipping_state;
                    $order->shipping_country = $shipping_country;
                    $order->shipping_area = $shipping_area;
                    $order->offer_code = $offer_code;
                    $order->offer_amount = $offer_amount;
                    $order->transaction_type = $transaction_type;
                    if ($transaction_type != 1) {
                        $order->transaction_id = $transaction_id;
                    } else {
                        $order->transaction_id = "";
                    }
                    $order->delivery_charge = $delivery_charge;
                    $order->grand_total = $grand_total;
                    $order->sub_total = $sub_total;
                    $order->tax_amount = $tax_amount;
                    $order->notes = $notes;
                    $order->status = 1;
                    if ($transaction_type == 6) {
                        $order->screenshot = $filename;
                    }
                    if ($order->save()) {
                       
                        foreach ($checkcart as $cart) {
                            $od = new OrderDetails();
                            $od->vendor_id = @$vdata;
                            $od->order_id = $order->id;
                            $od->user_id = $user_id;
                            $od->session_id = session()->getId();
                            $od->product_id = $cart->product_id;
                            $od->product_name = $cart->product_name;
                            $od->product_slug = $cart->product_slug;
                            $od->product_image = $cart->product_image;
                            $od->variation_id = $cart->variation_id;
                            $od->variation_name = $cart->variation_name;
                            $od->attribute = $cart->attribute;
                            $od->product_tax = $cart->product_tax;
                            $od->product_price = $cart->product_price;
                            $od->qty = $cart->qty;
                            $od->save();
                            if ($cart->variation_id == 0 || $cart->variation_id == "" || $cart->variation_id == null) {
                                $product = Products::where('id', $cart->product_id)->where('vendor_id',$cart->vendor_id)->first();
                                $product->qty = $product->qty != 0 ?  (int)$product->qty - (int)$cart->qty : 0 ;
                                $product->update();
                            } else {
                               
                                $variant = Variation::where('product_id', $cart->product_id)->where('id', $cart->variation_id)->first();
                                $variant->qty = $variant->qty !=0 ? (int)$variant->qty - (int)$cart->qty : 0 ;
                                $variant->update();
                            }
                            $cart->delete();
                        }
                        if ($checkplan->appoinment_limit != -1) {
                            $checkplan->appoinment_limit -= 1;
                            $checkplan->save();
                        }
                        $orderdata = Order::where('id', $order->id)->first();
                        $emaildata = helper::emailconfigration($vdata);
                        Config::set('mail',$emaildata);
                        helper::create_order_invoice($user_email, $user_name,$vendordata->email,$vendordata->name,$vdata,$order_number,helper::date_formate($orderdata->created_at),$trackurl,helper::currency_formate($grand_total,$vdata));
                       
                       
                        return response()->json(['status' => 1, 'message' => trans('messages.success'), 'successurl' => $successurl, 'order_number' => $order_number], 200);
                    } else {
                        return response()->json(['status' => 0, 'message' => trans('messages.wrong')], 200);
                    }
                }
                else
                {
                   
                    return response()->json(['status' => 0, 'message' => trans('messages.cart_empty')], 200);
                }
             
            } else {
                return response()->json(['status' => 0, 'message' => trans('messages.wrong')], 200);
            }
        } catch (\Throwable $th) {
            return response()->json(['status' => 0, 'message' => trans('messages.wrong')], 200);
        }
    }
 
 
    public static function whatsappmessage($order_number, $vendor_slug, $vendordata)
    {
        $pagee[]="";
        $payment_type = "-";
        $payment_status = "";
        $getorder = Order::where('order_number', $order_number)->first();
        if ($getorder->payment_status == "1") {
            $payment_status = "UnPaid";
        }
        if ($getorder->payment_status == "2") {
            $payment_status = "Paid";
        }
        if (strtolower($getorder->transaction_type) == "1") {
            $payment_type = "COD";
        }
        if (strtolower($getorder->transaction_type) == "2") {
            $payment_type = "RazorPAy";
        }
        if (strtolower($getorder->transaction_type) == '3') {
            $payment_type = "Stripe";
        }
        if (strtolower($getorder->transaction_type) == '4') {
            $payment_type = "Flutterwave";
        }
        if (strtolower($getorder->transaction_type) == '5') {
            $payment_type = "PayStack";
        }
        if (strtolower($getorder->transaction_type) == '6') {
            $payment_type = "Bank Transfer";
        }
        if (strtolower($getorder->transaction_type) == '7') {
            $payment_type = "Mercadopago";
        }
        if (strtolower($getorder->transaction_type) == '8') {
            $payment_type = "PayPal";
        }
        if (strtolower($getorder->transaction_type) == '9') {
            $payment_type = "MyFatoorah";
        }
        if (strtolower($getorder->transaction_type) == '9') {
            $payment_type = "Toyyibpay";
        }
        $data = OrderDetails::where('order_id', $getorder->id)->get();
        foreach ($data as $value) {
            if ($value['variation_id'] != "") {
                $item_p =  $value['product_price'];
                $variantsdata = '(' . $value['variation_name'] . ')';
            } else {
                $variantsdata = "";
                $item_p =  $value['product_price'];
            }
            $extras_id = explode(",", $value['extras_id']);
            $extras_name = explode(",", $value['extras_name']);
            $extras_price = explode(",", $value['extras_price']);
            $item_message = helper::appdata($vendordata->id)->item_message;
            $itemvar = ["{qty}", "{item_name}", "{variantsdata}", "{item_price}"];
            $newitemvar   = [$value['qty'], $value['product_name'], $variantsdata, helper::currency_formate($item_p, $vendordata->id)];
            $pagee[] = str_replace($itemvar, $newitemvar, $item_message);
            if ($value['extras_id'] != "") {
                foreach ($extras_id as $key =>  $addons) {
                    $pagee[] .= "👉" . $extras_name[$key] . ':' . helper::currency_formate($extras_price[$key], $vendordata->id) . '%0a';
                }
            }
        }

        $items = implode(",", $pagee);
        $itemlist = str_replace(',', '%0a', $items);
        $var = ["{order_no}", "{payment_status}", "{item_variable}", "{sub_total}", "{total_tax}", "{offer_code}", "{discount_amount}", "{delivery_charge}", "{grand_total}", "{notes}", "{customer_name}", "{customer_mobile}", "{customer_email}", "{billing_address}", "{billing_city}", "{billing_state}", '{billing_country}', "{billing_landmark}", "{billing_postal_code}", "{shipping_address}", "{shipping_city}", "{shipping_state}", "{shipping_country}", "{shipping_postal_code}", "{shipping_landmark}", "{payment_type}", "{track_order_url}", "{store_url}", "{store_name}"];
        $newvar   = [$getorder->order_number, $payment_status, $itemlist, helper::currency_formate($getorder->sub_total, $vendordata->id), helper::currency_formate($getorder->tax_amount, $vendordata->id), $getorder->offer_code, helper::currency_formate($getorder->offer_amount, $vendordata->id), helper::currency_formate($getorder->delivery_charge, $vendordata->id), helper::currency_formate($getorder->grand_total, $vendordata->id), $getorder->notes, $getorder->user_name, $getorder->user_mobile, $getorder->user_email, $getorder->billing_address, $getorder->billing_city, $getorder->billing_state, $getorder->billing_country, $getorder->billing_landmark, $getorder->billing_postal_code,  $getorder->shipping_address, $getorder->shipping_city, $getorder->shipping_state, $getorder->shipping_country, $getorder->shipping_postal_code, $getorder->shipping_landmark, $payment_type, URL::to($vendordata->slug . '/find-order?order=' . $order_number), URL::to($vendordata->slug), $vendor_slug];
        $whmessage = str_replace($var, $newvar, str_replace("\n", "%0a", helper::appdata($vendordata->id)->whatsapp_message));

        return $whmessage;
    }
    public static function ceckfavorite($product_id,$vendor_id,$user_id)
    {
        $getfavorite = Favorite::where('vendor_id',$vendor_id)->where('user_id',$user_id)->where('product_id',$product_id)->first();
        return $getfavorite;
    }
    
    public static function language()
    {
        if (session()->get('locale') == null) {
            $layout = Languages::select('name','layout','image','is_default','code')->where('is_default',1)->first();
        
            App::setLocale($layout->code);
            session()->put('locale', $layout->code);
            session()->put('language', $layout->name);
            session()->put('flag', $layout->image);
            session()->put('direction', $layout->layout);
        } else {
            $layout = Languages::select('layout')->where('code', session()->get('locale'))->first();
        
            App::setLocale(session()->get('locale'));

            session()->put('direction', @$layout->layout);
        }
    }

    public static function listoflanguage()
    {
        $listoflanguage = Languages::where('is_available', '1')->get();
        return $listoflanguage;
    }

    public static function vendor_register($vendor_name, $vendor_email, $vendor_mobile, $vendor_password, $firebasetoken, $slug, $google_id, $facebook_id, $country_id, $city_id)
    {
        try {
            if (!empty($slug)) {
                $slug;
            } else {
                $check = User::where('slug', Str::slug($vendor_name, '-'))->first();
                if ($check != "") {
                    $last = User::select('id')->orderByDesc('id')->first();
                    $slug =   Str::slug($vendor_name . " " . ($last->id + 1), '-');
                } else {
                    $slug = Str::slug($vendor_name, '-');
                }
            }
            $rec = Settings::where('vendor_id', '1')->first();

            date_default_timezone_set($rec->timezone);
            $logintype = "normal";
            if ($google_id != "") {
                $logintype = "google";
            }

            if ($facebook_id != "") {
                $logintype = "facebook";
            }

            $user = new User();
            $otp = rand(111111, 999999);
            $user->name = $vendor_name;
            $user->email = $vendor_email;
            $user->password = $vendor_password;
            $user->google_id = $google_id;
            $user->facebook_id = $facebook_id;
            $user->mobile = $vendor_mobile;
            $user->login_type = $logintype;
            $user->type = 2;
            $user->image = "default.png";
            $user->token = $firebasetoken;
            $user->slug = $slug;
            $user->is_available = "1";
            $user->is_verified = "1";
            $user->otp = $otp;
            $user->country_id = $country_id;
            $user->city_id = $city_id;
            $user->save();
            $vendor_id = \DB::getPdo()->lastInsertId();

            $paymentlist = Payment::where('vendor_id', '1')->get();
            foreach ($paymentlist as $payment) {
                $gateway = new Payment;
                $gateway->vendor_id = $vendor_id;
                $gateway->payment_name = $payment->payment_name;
                $gateway->currency = $payment->currency;
                $gateway->image = $payment->image;
                $gateway->public_key = '-';
                $gateway->secret_key = '-';
                $gateway->encryption_key = '-';
                $gateway->payment_type = $payment->payment_type;
                $gateway->environment = '1';
                $gateway->is_available = '1';
                $gateway->is_activate = $payment->is_activate;
                $gateway->save();
            }

            $messagenotification = "Hi, 
I would like to place an order 👇

Order No: {order_no}
---------------------------
{item_variable}
---------------------------
👉Subtotal : {sub_total}
👉Tax : {total_tax}
👉Delivery charge : {delivery_charge}
👉Discount : - {discount_amount}
---------------------------
📃 Total : {grand_total}
---------------------------
📄 Comment : {notes}
✅ Customer Info
---------------------------
Customer name : {customer_name}
Customer email: {customer_email}
Customer phone : {customer_mobile}
---------------------------
📍 Billing Details
Address : {billing_address}, {billing_landmark}, {billing_postal_code}, {billing_city}, {billing_state}, {billing_country}.
---------------------------
📍 Shipping Details
Address : {shipping_address}, {shipping_landmark}, {shipping_postal_code}, {shipping_city}, {shipping_state}, {shipping_country}.
---------------------------
🗓️Date : {date}
⏱️Time : {time}
---------------------------
💳 Payment type : {payment_type}

{store_name} will confirm your order upon receiving the message.

Track your order 👇
{track_order_url}

Click here for next order 👇
{store_url}

Thanks for the Order 🥳";
          
            $data = new Settings();
            $data->logo = "defaultlogo.png";
            $data->favicon = "defaultlogo.png";
            $data->viewallpage_banner = "";
            $data->email = $vendor_email;
            $data->mobile = $vendor_mobile;
            $data->contact = $vendor_mobile;
            $data->address = "ADDRESS";
            $data->currency = helper::appdata("")->currency;
            $data->currency_position = helper::appdata("")->currency_position;
            $data->timezone = helper::appdata("")->timezone;
            $data->web_title = helper::appdata("")->web_title;
            $data->copyright = helper::appdata("")->copyright;
            $data->vendor_id = $vendor_id;
            $data->primary_color = "#16162e";
            $data->secondary_color = "#f15a24";
            $data->whatsapp_message = $messagenotification;
            $data->telegram_message = $messagenotification;
            $data->whatsapp_number = $vendor_mobile;
            $data->item_message = "🔵{item_name} X  {qty}  {variantsdata} - {item_price}";
            $data->save();
            $emaildata = helper::emailconfigration(helper::appdata('')->id);
            Config::set('mail', $emaildata);
            helper::send_mail_vendor_register($user);
            return $vendor_id;
        } catch (\Throwable $th) {
            return $th;
        }
    }

    public static function product_count($category_id)
    {
        $count = Products::where('category_id',$category_id)->count();
        return $count;
    }
    public static function role($id)
    {
        $role = RoleManager::where('id', $id)->first();
        return $role;
    }
    public static function check_menu($role_id, $slug)
    {
        if (Auth::user()->type == 4) {
            $vendor_id = Auth::user()->vendor_id;
        } else {
            $vendor_id = Auth::user()->id;
        }
        
        if ($role_id == "" || $role_id == null || $role_id == 0) {
            return 1;
        } else {
            $module = RoleManager::where('id', $role_id)->where('vendor_id',$vendor_id)->first();
            $module = explode(',', $module->module);
            if (in_array($slug,$module)) {
                return 1;
            } else {

                return 0;
            }
        }
    }
    public static function check_access($module, $role_id, $vendor_id, $action)
    {
        $module = RoleAccess::where('module_name', $module)->where('role_id', $role_id)->where('vendor_id', $vendor_id)->first();
        if (!empty($module) && $module != null) {
            if ($action == 'add' && $module->add == 1) {
                return 1;
            } elseif ($action == 'edit' && $module->edit == 1) {
                return 1;
            } elseif ($action == 'delete' && $module->delete == 1) {
                return 1;
            } elseif ($action == 'manage' && $module->manage == 1) {
                return 1;
            } else {
                return 0;
            }
        } else {
            return 0;
        }
    }
    public static function getplantransaction($vendor_id)
    {
        $plan = Transaction::where('vendor_id', $vendor_id)->orderbyDesc('id')->first();
        return $plan;
    }
    public static function getslug($vendor_id)
    {
        $data = User::where('id',$vendor_id)->first();
        return $data;
    }
    public static function getpixelid($vendor_id)
    {
        $pixcel = Pixcel::where('vendor_id',$vendor_id)->first();
        return $pixcel;
    }
    public static function checklowqty($item_id, $vendor_id)
    {
        $item = Products::where('id', $item_id)->where('vendor_id', $vendor_id)->first();
        if ($item->has_variation == 1) {
            $qty = Variation::select('qty')->where('product_id', $item_id)->get();
            foreach ($qty as $qty) {
                if ($qty->qty <= $item->low_qty) {
                    return 1;
                }
            }
        } else {
            if ($item->qty <= $item->low_qty) {
                return 1;
            }
        }
    }
    // dynamic email configration
    public static function emailconfigration($vendor_id)
    {
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = User::where('id',$vendor_id)->where('is_available', 1)->first();
            $vdata = $vendordata->id;
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
            $vdata = $vendordata->vendor_id;
        }
        $mailsettings = Settings::where('vendor_id',$vdata)->first();
        if($mailsettings){
            $emaildata = [
                'driver' => $mailsettings->mail_driver,
                'host' => $mailsettings->mail_host,
                'port' => $mailsettings->mail_port,
                'encryption' => $mailsettings->mail_encryption,
                'username' => $mailsettings->mail_username,
                'password' => $mailsettings->mail_password,
                'from'     => ['address'=>$mailsettings->mail_fromaddress,'name'=>$mailsettings->mail_fromname]
            ];
        }
        return $emaildata;
    }
    public static function getpayment($payment_type,$vendor_id)
    {
        $payment = Payment::where('payment_type',$payment_type)->where('vendor_id', $vendor_id)->first();
        return $payment;
    }
    public static function paymentlist($vendor_id)
    {
        $payment = Payment::where('vendor_id',$vendor_id)->where('is_available',1)->where('is_activate',1)->get();
        return $payment;
    }
    public static function top_deals($vendor_id)
    {
        $topdeals = TopDeals::where('vendor_id',$vendor_id)->first();
        return $topdeals;
    }
    public static function push_notification($token, $title, $body, $type, $order_id,$firebase)
    {
        $customdata = array(
            "type" => $type,
            "order_id" => $order_id,
        );

        $msg = array(
            'body' => $body,
            'title' => $title,
            'sound' => 1/*Default sound*/
        );
        $fields = array(
            'to'           => $token,
            'notification' => $msg,
            'data' => $customdata
        );
        $headers = array(
            'Authorization: key=' . @$firebase,
            'Content-Type: application/json'
        );
        #Send Reponse To FireBase Server
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
        $firebaseresult = curl_exec($ch);
        curl_close($ch);
        return $firebaseresult;
    }

    public static function checkcustomdomain($vendor_id)
    {
        $customdomain = Customdomain::select('current_domain')->where('vendor_id',$vendor_id)->where('status',2)->first();

        return @$customdomain->current_domain;
    }
}