@extends('admin.layout.default')
@section('content')
    <div class="mb-3">
        <h5 class="text-uppercase">{{ trans('labels.product_upload') }}</h5>
    </div>
    <div class="row">
        <div class="col-12 mb-3">
            <div class="card border-0 box-shadow mb-3">

                <div class="card-body">
                    <h5 class="mb-2">{{trans('labels.step_1')}}</h5>
                    <ul>
                        <li>1. {{trans('labels.download_file')}}</li>
                        <li>2. {{trans('labels.download_example_file_to_understand')}}</li>
                        <li>3. {{trans('labels.upload_submit')}}</li>
                        <li>4. {{trans('labels.after_uploading_products')}}</li>
                    </ul>
                </div>
            </div>
            <a href="{{url(env('ASSETPATHURL') . 'admin-assets/sample.xlsx') }}" class="btn btn-primary mb-3">{{trans('labels.download_CSV')}}</a>
            <div class="card border-0 box-shadow mb-3">

                <div class="card-body">
                    <h5 class="mb-2">{{trans('labels.step_2')}}</h5>
                    <ul>
                        <li>1. {{trans('labels.category_numeric')}}</li>
                        <li>2. {{trans('labels.download_pdf')}}</li>
                    </ul>
                </div>
            </div>
            <div class="d-flex mb-3">
                <a href="{{ URL::to('/admin/generatepdf') }}" class="btn btn-primary mx-2">{{trans('labels.download_category')}}</a>
                <a href="{{ URL::to('/admin/generatepdf_subcategory') }}" class="btn btn-primary">{{trans('labels.download_subcategory')}}</a>
            </div>
            
            <form action="{{ URL::to('/admin/importproduct') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="col-12 form-group">
                    <label class="form-label">{{ trans('labels.product_upload') }}<span class="text-danger"> *
                        </span></label>
                    <input type="file" class="form-control" name="importfile" id="importfile" multiple="" required>
                </div>
                <button class="btn btn-primary">{{trans('labels.import')}}</button>
            </form>
        </div>
    </div>
@endsection
