<!-- FOOTER AREA START -->
<footer class="mb-lg-0 pb-lg-0 mb-5 pb-2">
    @if (count(Helper::footer_features(@$vendordata->id)) > 0)
        <div class="bg-light">
            <div class="container py-4 ">
                <div class="row justify-content-center border-bottom pb-3">
                    @foreach (Helper::footer_features(@$vendordata->id) as $feature)
                        <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 mb-2">
                            <div class="footer-widget">
                                <div class="widget-wrapper d-flex align-items-start justify-content-center">
                                    <div class="fs-4 widget-icon text-dark"> {!! $feature->icon !!} </div>
                                    <div class="widget-content px-3">
                                        <h5 class="text-primary fw-500 text-dark mb-0 text-truncate">
                                            {{ $feature->title }}</h5>
                                        <p class="fs-7 line-2">{{ $feature->description }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endif
    <div class="border-bottom footer-py border-light bg-light">
        <div class="container">
            <div class="row justify-content-between">
                <div class="col-lg-3 col-12 mb-3">
                    <div class="footer-content">
                        <a href="#">
                            <img src="{{ helper::image_path(@helper::appdata(@$vendordata->id)->logo) }}"
                                class="object-fit-contain logo-h-50-px" alt="footer_logo">
                        </a>
                        <p class="mt-4 mb-3 text-dark line-3">
                            {{ @helper::appdata(@$vendordata->id)->footer_description }}
                        </p>
                        <div class="mb-1 d-flex"> <i
                                class="fa-regular fa-house fs-7 text-dark {{ session()->get('direction') == 2 ? 'ms-2' : 'me-2' }}"></i>
                            <span class="fs-7 text-dark">{{ @helper::appdata(@$vendordata->id)->address }}</span>
                        </div>
                        <div class="mb-1 d-flex"> <i
                                class="fa-regular fa-phone fs-7 text-dark {{ session()->get('direction') == 2 ? 'ms-2' : 'me-2' }}"></i>
                            <a href="tel:{{ helper::appdata($vendordata->id)->contact }}"><span
                                    class="fs-7 text-dark">{{ @helper::appdata(@$vendordata->id)->contact }}</span></a>
                        </div>
                        <div class="mb-1 d-flex"> <i
                                class="fa-regular fa-envelope fs-7 text-dark {{ session()->get('direction') == 2 ? 'ms-2' : 'me-2' }}"></i>
                            <a href="mailto:{{ helper::appdata($vendordata->id)->email }}"> <span
                                    class="fs-7 text-dark">{{ @helper::appdata(@$vendordata->id)->email }}</span></a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-8">
                    <div class="row justify-content-md-around">
                        <div class="col-lg-3 col-6 mb-3">
                            <div class="footer-content">
                                <p class="text-dark fw-600 mb-3 text-capitalize fs-5">{{ trans('labels.information') }}
                                </p>
                                <ul>
                                    <li class="mb-1"><a class="text-dark"
                                            href="{{ URL::to(@$vendordata->slug . '/') }}">{{ trans('labels.home') }}</a>
                                    </li>
                                    <li class="mb-1"><a class="text-dark"
                                            href="{{ URL::to(@$vendordata->slug . '/shop_all') }}">{{ trans('labels.shop_all') }}</a>
                                    </li>
                                    <li class="mb-1"><a class="text-dark"
                                            href="{{ URL::to(@$vendordata->slug . '/categories') }}">{{ trans('labels.categories') }}</a>
                                    </li>
                                    @if (App\Models\SystemAddons::where('unique_identifier', 'subscription')->first() != null &&
                                            App\Models\SystemAddons::where('unique_identifier', 'subscription')->first()->activated == 1)
                                        @if (App\Models\SystemAddons::where('unique_identifier', 'blog')->first() != null &&
                                                App\Models\SystemAddons::where('unique_identifier', 'blog')->first()->activated == 1)
                                            @php
                                                $checkplan = App\Models\Transaction::where('vendor_id', $vendordata->id)
                                                    ->orderByDesc('id')
                                                    ->first();
                                                
                                                if ($vendordata->allow_without_subscription == 1) {
                                                    $blogs = 1;
                                                } else {
                                                    $blogs = @$checkplan->blogs;
                                                }
                                            @endphp
                                            @if ($blogs == 1)
                                                <li class="mb-1"><a class="text-dark"
                                                        href="{{ URL::to(@$vendordata->slug . '/blogs') }}">{{ trans('labels.blog') }}</a>
                                                </li>
                                            @endif
                                        @endif
                                    @else
                                        @if (App\Models\SystemAddons::where('unique_identifier', 'blog')->first() != null &&
                                                App\Models\SystemAddons::where('unique_identifier', 'blog')->first()->activated == 1)
                                            <li class="mb-1"><a class="text-dark"
                                                    href="{{ URL::to(@$vendordata->slug . '/blogs') }}">{{ trans('labels.blog') }}</a>
                                            </li>
                                        @endif
                                    @endif

                                    <li class="mb-1"><a class="text-dark"
                                            href="{{ URL::to(@$vendordata->slug . '/gallery') }}">{{ trans('labels.gallery') }}</a>
                                    </li>
                                    <li class="mb-1"><a class="text-dark"
                                            href="{{ URL::to(@$vendordata->slug . '/find-order') }}">{{ trans('labels.Track_Order') }}</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6 mb-3">
                            <div class="footer-content">
                                <p class="text-dark fw-600 mb-3 text-capitalize fs-5">{{ trans('labels.get_help') }}
                                </p>
                                <ul>
                                    <li class="mb-1"><a class="text-dark"
                                            href="{{ URL::to(@$vendordata->slug . '/termscondition') }}">{{ trans('labels.terms_condition') }}</a>
                                    </li>
                                    <li class="mb-1"><a class="text-dark"
                                            href="{{ URL::to(@$vendordata->slug . '/privacypolicy') }}">{{ trans('labels.privacy_policy') }}</a>
                                    </li>
                                    <li class="mb-1"><a class="text-dark"
                                            href="{{ URL::to(@$vendordata->slug . '/refund_policy') }}">{{ trans('labels.refund_policy') }}</a>
                                    </li>
                                    <li class="mb-1"><a class="text-dark"
                                            href="{{ URL::to(@$vendordata->slug . '/aboutus') }}">{{ trans('labels.about_us') }}</a>
                                    </li>
                                    <li class="mb-1"><a class="text-dark"
                                            href="{{ URL::to(@$vendordata->slug . '/contact-us') }}">{{ trans('labels.help_contact') }}</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-4 col-xl-4 col-12 col-auto mb-3">
                            <div class="footer-content">
                                <div class="mb-3">
                                    <p class="text-dark fw-600 mb-3 text-capitalize fs-5">
                                        {{ trans('labels.follow_us') }}</p>
                                    <ul class="follow d-flex g-16">
                                        @if (helper::appdata($vendordata->id)->facebook_link != null || helper::appdata($vendordata->id)->facebook_link != '')
                                            <li class="mb-1"> <a class="text-dark"
                                                    href="{{ @helper::appdata(@$vendordata->id)->facebook_link != '' ? URL::to(@helper::appdata(@$vendordata->id)->facebook_link) : 'javascript:void(0)' }}"
                                                    target="_blank"> <i
                                                        class="fa-brands fa-facebook fs-5 {{ session()->get('direction') == 2 ? 'ms-2' : 'me-2' }}"></i>
                                                </a>
                                            </li>
                                        @endif
                                        @if (helper::appdata($vendordata->id)->twitter_link != null || helper::appdata($vendordata->id)->twitter_link != '')
                                            <li class="mb-1"> <a class="text-dark"
                                                    href="{{ @helper::appdata(@$vendordata->id)->twitter_link != '' ? URL::to(@helper::appdata(@$vendordata->id)->twitter_link) : 'javascript:void(0)' }}"
                                                    target="_blank"> <i
                                                        class="fa-brands fa-twitter fs-5 {{ session()->get('direction') == 2 ? 'ms-2' : 'me-2' }}"></i>
                                                </a>
                                            </li>
                                        @endif
                                        @if (helper::appdata($vendordata->id)->instagram_link != null || helper::appdata($vendordata->id)->instagram_link != '')
                                            <li class="mb-1"> <a class="text-dark"
                                                    href="{{ @helper::appdata(@$vendordata->id)->instagram_link != '' ? URL::to(@helper::appdata(@$vendordata->id)->instagram_link) : 'javascript:void(0)' }}"
                                                    target="_blank"> <i
                                                        class="fa-brands fa-instagram fs-5 {{ session()->get('direction') == 2 ? 'ms-2' : 'me-2' }}"></i>
                                                </a>
                                            </li>
                                        @endif
                                        @if (helper::appdata($vendordata->id)->linkedin_link != null || helper::appdata($vendordata->id)->linkedin_link != '')
                                            <li class="mb-1"> <a class="text-dark"
                                                    href="{{ @helper::appdata(@$vendordata->id)->linkedin_link != '' ? URL::to(@helper::appdata(@$vendordata->id)->linkedin_link) : 'javascript:void(0)' }}"
                                                    target="_blank"> <i
                                                        class="fa-brands fa-linkedin fs-5 {{ session()->get('direction') == 2 ? 'ms-2' : 'me-2' }}"></i>
                                                </a>
                                            </li>
                                        @endif
                                    </ul>
                                </div>
                                <div class="subscribe-box">
                                    <p class="text-dark fw-600 mb-3 text-capitalize fs-5">
                                        {{ trans('labels.subscribe') }}</p>
                                    <span class="text-dark">{{ trans('labels.footer_subscribe_subtitle') }}</span>
                                </div>
                                <form action="{{ URL::to($vendordata->slug . '/subscribe') }}" method="POST"
                                    class="mt-3">
                                    @csrf
                                    <div class="input-group">
                                        <input type="text"
                                            class="form-control border text-dark fw-500 rounded-0 bg-light {{ session()->get('direction') == 2 ? 'ms-2' : 'me-2' }}"
                                            name="subscribe_email" placeholder="example@yormailer.com" required>
                                        <button class="btn btn-primary subscribe-btn rounded-0"
                                            type="submit">{{ trans('labels.subscribe') }} </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-bottom bg-light py-3 border-top">
        <div class="container text-center text-dark d-md-flex align-items-center justify-content-between">
            <p class="mb-2 mb-dm-0">{{ @helper::appdata(@$vendordata->id)->copyright }}</p>
            @php
                $paymentlist = helper::paymentlist($vendordata->id);
            @endphp
            <ul class="footer_acceped_card d-flex justify-content-center m-0">
                @foreach ($paymentlist as $payment)
                <li class="me-2"><img
                    src="{{helper::image_path($payment->image)}}" class="h-30px mb-3"
                    alt=""></li>
                @endforeach
            </ul>
        </div>
    </div>
</footer>
<!-- FOOTER AREA END -->
