@extends('web.layout.default')

@section('contents')

    <!-- BREADCRUMB AREA START -->

    <section class="py-5 bg-light">

        <div class="container">

            <nav aria-label="breadcrumb">



                @if (!empty($getsubcategorydata))
                    <h2 class="breadcrumb-title mb-2">{{ $getsubcategorydata->name }}</h2>
                @elseif(empty($getcategorydata) && empty($getsubcategorydata) && request()->has('category'))
                    <h2 class="breadcrumb-title"> {{ request()->get('category') }} </h2>
                @elseif (!empty($getcategorydata) && empty($getsubcategorydata))
                    <h2 class="breadcrumb-title">{{ $getcategorydata->name }}</h2>
                @else
                    <h2 class="breadcrumb-title">{{ trans('labels.shop_all') }}</h2>
                @endif


                <ol class="breadcrumb justify-content-center">

                    <li
                        class="{{ @helper::appdata(@$vendordata->id)->web_layout == 2 ? 'breadcrumb-item-rtl' : 'breadcrumb-item' }}">
                        <a class="text-dark" href="{{ URL::to(@$vendordata->slug . '/') }}">{{ trans('labels.home') }}</a>
                    </li>

                    @if (request()->category_slug == null || request()->category_slug == '')
                        <li class="text-muted {{ @helper::appdata(@$vendordata->id)->web_layout == 2 ? 'breadcrumb-item-rtl' : 'breadcrumb-item' }} active"
                            aria-current="page">{{ trans('labels.shop_all') }}</li>
                    @else
                        <li
                            class="{{ @helper::appdata(@$vendordata->id)->web_layout == 2 ? 'breadcrumb-item-rtl' : 'breadcrumb-item' }}">
                            <a class="text-dark"
                                href="{{ URL::to(@$vendordata->slug . '/categories') }}">{{ trans('labels.categories') }}</a>

                        </li>
                    @endif


                    @if (!empty($getcategorydata))
                        @if (empty($getsubcategorydata))
                            <li class="text-muted {{ @helper::appdata(@$vendordata->id)->web_layout == 2 ? 'breadcrumb-item-rtl' : 'breadcrumb-item' }} active"
                                aria-current="page">{{ $getcategorydata->name }}</li>
                        @else
                            <li
                                class="{{ @helper::appdata(@$vendordata->id)->web_layout == 2 ? 'breadcrumb-item-rtl' : 'breadcrumb-item' }}">
                                <a class="text-dark"
                                    href="{{ URL::to(@$vendordata->slug . '/categories-' . $getcategorydata->slug) }}">{{ $getcategorydata->name }}</a>
                            </li>
                        @endif
                    @endif

                    @if (!empty($getsubcategorydata))
                        <li class="text-muted {{ @helper::appdata(@$vendordata->id)->web_layout == 2 ? 'breadcrumb-item-rtl' : 'breadcrumb-item' }} active"
                            aria-current="page">{{ $getsubcategorydata->name }}</li>
                    @endif

                </ol>

            </nav>

        </div>

    </section>

    <!-- BREADCRUMB AREA END -->

    <!-- PRODUCTS LIST AREA START -->

    <section class="product-list">

        <div class="container py-5">

            @if (!empty(@helper::appdata(@$vendordata->id)->viewallpage_banner))
                <img class="w-100 mb-4 object-fit-cover rounded h-250-px"
                    src="{{ helper::image_path(@helper::appdata(@$vendordata->id)->viewallpage_banner) }}">
            @endif

            <div class="filter row mt-5 mb-4">

                <div class="col-12 col-md-auto">
                    <div class="row mb-3 gx-2 mb-md-0">
                        <div class="col-12 col-md-6 mb-3 mb-md-0">
                            <label for="category" class="form-label">{{trans('labels.categories')}}</label>
                            <select class="form-select form-select-sm select-auto-expand form-select-p"
                                aria-label="Default select example"
                                onchange="location =  $('option:selected',this).data('value');" name="category"
                                id="category">
                                <option class="select-auto-expand__select" data-value="{{ URL::to($vendordata->slug . '/products?category='.'&subcategory='.request()->get('subcategory')) }}" selected>
                                    {{ trans('labels.select') }}</option>
                                @foreach (helper::getcategories(@$vendordata->id, '') as $category)
                                    <option class="select-auto-expand__select"
                                        {{ request()->category_slug  == $category->slug || request()->get('category')  == $category->slug ? 'selected' : '' }}
                                        value="{{ $category->slug }}"
                                        data-value="{{ URL::to($vendordata->slug . '/products?category=' . $category->slug) }}">
                                        {{ $category->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        @php
                            if(request()->has("category"))
                            {
                                $category = request()->get('category');
                            }
                            else{
                                $category = request()->category_slug;
                            }

                        @endphp
                        <div class="col-12 col-md-6">
                            <label for="subcategory" class="form-label">{{trans('labels.sub_categories')}}</label>
                            <select class="form-select form-select-sm select-auto-expand form-select-p"
                                aria-label="Default select example" onchange="location =  $('option:selected',this).data('value');" name="subcategory"
                                id="subcategory">
                                <option class="select-auto-expand__select" data-value="{{ URL::to(@$vendordata->slug . '/products?category=' . $category . '&subcategory=') }}" selected>{{ trans('labels.select') }}
                                </option>
                                @foreach ($subcategories as $subcategory)
                                    <option class="select-auto-expand__select" value="{{ $subcategory->slug }}" data-value="{{ URL::to(@$vendordata->slug . '/products?category=' . $category . '&subcategory=' . $subcategory->slug) }}"    {{ request()->get('subcategory')  == $subcategory->slug  ? 'selected' : '' }}>
                                            {{ $subcategory->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-md-auto">
                    <label for="filter_by" class="form-label">{{trans('labels.filter_by')}}</label>
                    <select class="form-select form-select-sm form-select-p w-100 select-auto-expand"
                        onchange="location = $(this).find(':selected').attr('data-url');" name="filter_by">

                        <option class="select-auto-expand__select"
                            data-url="{{ URL::to(@$vendordata->slug . '/products-all?category='. request()->get('category') .'&subcategory='. request()->get('subcategory')) }}" selected>
                            {{ trans('labels.select') }}</option>

                        <option class="select-auto-expand__select"
                            data-url="{{ URL::to(@$vendordata->slug . '/products-newest?category='. request()->get('category') .'&subcategory='. request()->get('subcategory')) }}"
                            {{ strpos(request()->url(), 'newest') ? 'selected' : '' }}>
                            {{ trans('labels.newest') }}</option>

                        <option data-url="{{ URL::to(@$vendordata->slug . '/products-oldest?category='. request()->get('category') .'&subcategory='. request()->get('subcategory')) }}"
                            {{ strpos(request()->url(), 'oldest') ? 'selected' : '' }}>
                            {{ trans('labels.oldest') }}</option>

                        <option class="select-auto-expand__select"
                            data-url="{{ URL::to(@$vendordata->slug . '/products-best-selling-products?category='. request()->get('category') .'&subcategory='. request()->get('subcategory')) }}"
                            {{ strpos(request()->url(), 'best-selling-products') ? 'selected' : '' }}>
                            {{ trans('labels.best_selling_products') }}</option>

                        <option class="select-auto-expand__select"
                            data-url="{{ URL::to(@$vendordata->slug . '/products-price-low-high?category='. request()->get('category') .'&subcategory='. request()->get('subcategory')) }}"
                            {{ strpos(request()->url(), 'price-low-high') ? 'selected' : '' }}>
                            {{ trans('labels.price_low_high') }}</option>

                        <option class="select-auto-expand__select"
                            data-url="{{ URL::to(@$vendordata->slug . '/products-price-high-low?category='. request()->get('category') .'&subcategory='. request()->get('subcategory')) }}"
                            {{ strpos(request()->url(), 'price-high-low') ? 'selected' : '' }}>
                            {{ trans('labels.price_high_low') }}</option>

                    </select>

                </div>

            </div>
            @if (count($getproductslist) > 0)
                <div class="row row-cols-2 row-cols-sm-2 row-cols-md-3 row-cols-lg-5 list-view">

                    @foreach ($getproductslist as $getproductdata)
                        @include('web.productcommonview')
                    @endforeach

                </div>
            @else
                @include('web.nodata')
            @endif

            {{ $getproductslist->appends(request()->query())->links() }}
            <div class="row">

            </div>

        </div>

    </section>

    <!-- PRODUCTS LIST AREA END -->

@endsection

@section('scripts')
    <script src="{{ url(env('ASSETPATHURL') . 'web-assets/js/products.js') }}"></script>
@endsection
